/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.entity;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.entity.FlyingItem;
import io.github.sluggly.timemercenaries.init.EntityInit;
import io.github.sluggly.timemercenaries.init.SoundInit;
import io.github.sluggly.timemercenaries.missions.Mission;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class Portal
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_PORTAL_TYPE = SynchedEntityData.m_135353_(Portal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ITEM_COUNT = SynchedEntityData.m_135353_(Portal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int age = 0;
    public List<ItemStack> itemsToAnimate = new ArrayList<ItemStack>();
    public MissionItem[] itemsReward = new MissionItem[0];
    public int multiplier = 0;
    public int experienceReward = 0;
    private int spawnDelay = 0;
    private int currentIndex = 0;
    public boolean sendMissionMode = false;
    public ServerPlayer targetPlayer;

    public Portal(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void setup(int itemCount, PortalType type) {
        this.m_20088_().m_135381_(DATA_ITEM_COUNT, (Object)itemCount);
        this.m_20088_().m_135381_(DATA_PORTAL_TYPE, (Object)type.ordinal());
    }

    public PortalType getPortalType() {
        return PortalType.values()[(Integer)this.m_20088_().m_135370_(DATA_PORTAL_TYPE)];
    }

    public int getPortalLife() {
        return 70 + (Integer)this.m_20088_().m_135370_(DATA_ITEM_COUNT) * 15;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.age;
        if (this.age > this.getPortalLife()) {
            this.m_146870_();
        }
        if (!this.m_9236_().f_46443_) {
            if (this.sendMissionMode && this.age > 20 && this.currentIndex < this.itemsToAnimate.size() && this.targetPlayer != null && this.spawnDelay-- <= 0) {
                ItemStack stackToSpawn = this.itemsToAnimate.get(this.currentIndex);
                FlyingItem flyingItem = new FlyingItem((EntityType)EntityInit.FLYING_ITEM.get(), this.m_9236_());
                flyingItem.setItem(stackToSpawn);
                flyingItem.m_6034_(this.targetPlayer.m_20185_(), this.targetPlayer.m_20188_() - 0.5, this.targetPlayer.m_20189_());
                flyingItem.setTarget(this);
                this.m_9236_().m_7967_((Entity)flyingItem);
                this.spawnDelay = 10;
                ++this.currentIndex;
            } else if (!(this.sendMissionMode || this.age <= 20 || this.currentIndex >= this.itemsReward.length && this.experienceReward <= 0 || this.targetPlayer == null || this.spawnDelay-- > 0)) {
                if (this.currentIndex < this.itemsReward.length && this.itemsReward[this.currentIndex].entity != null) {
                    int number = this.itemsReward[this.currentIndex].number * this.multiplier;
                    for (int i = 0; i < number; ++i) {
                        this.itemsReward[this.currentIndex].entity.m_262496_((ServerLevel)this.targetPlayer.m_9236_(), this.m_20183_(), MobSpawnType.MOB_SUMMONED);
                    }
                    if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                        System.out.printf("Summoned %d x %s%n", number, this.itemsReward[this.currentIndex].entity.m_20675_());
                    }
                    this.spawnDelay = 10;
                } else if (this.currentIndex < this.itemsReward.length && this.itemsReward[this.currentIndex].itemStack != null) {
                    ItemStack rewardStack = this.itemsReward[this.currentIndex].itemStack.m_41777_();
                    int number = this.itemsReward[this.currentIndex].number * this.multiplier;
                    rewardStack.m_41764_(number);
                    ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), rewardStack);
                    Vec3 motion = this.targetPlayer.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                    itemEntity.m_20256_(motion.m_82490_(0.25).m_82520_(0.0, 0.2, 0.0));
                    itemEntity.m_32010_(10);
                    this.m_9236_().m_7967_((Entity)itemEntity);
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, this.m_5720_(), 0.4f, 2.0f, false);
                    if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                        System.out.println("Dropped %d x %d = %d ".formatted(this.itemsReward[this.currentIndex].number, this.multiplier, number) + this.itemsReward[this.currentIndex].getName());
                    }
                    this.spawnDelay = 10;
                } else if (this.experienceReward > 0) {
                    ExperienceOrb xpOrb = new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.experienceReward / 5);
                    this.experienceReward -= this.experienceReward / 5;
                    this.m_9236_().m_7967_((Entity)xpOrb);
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, this.m_5720_(), 0.4f, 2.0f, false);
                    this.spawnDelay = 4;
                }
                ++this.currentIndex;
            }
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_COUNT, (Object)0);
        this.m_20088_().m_135372_(DATA_PORTAL_TYPE, (Object)PortalType.BLUE.ordinal());
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.m_20088_().m_135381_(DATA_ITEM_COUNT, (Object)pCompound.m_128451_("ItemCount"));
        this.m_20088_().m_135381_(DATA_PORTAL_TYPE, (Object)pCompound.m_128451_("PortalType"));
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("ItemCount", ((Integer)this.m_20088_().m_135370_(DATA_ITEM_COUNT)).intValue());
        pCompound.m_128405_("PortalType", ((Integer)this.m_20088_().m_135370_(DATA_PORTAL_TYPE)).intValue());
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private static Vec3 getSafeSpawnPosition(ServerPlayer player) {
        Level level = player.m_9236_();
        Vec3 playerEyePos = player.m_146892_();
        Vec3 lookVector = player.m_20154_();
        for (double distance = 3.0; distance > 0.5; distance -= 0.1) {
            ClipContext clipContext;
            BlockHitResult hitResult;
            boolean isSpaceClear;
            Vec3 potentialSpawnPos = playerEyePos.m_82549_(lookVector.m_82490_(distance));
            BlockPos potentialBlockPos = BlockPos.m_274446_((Position)potentialSpawnPos);
            boolean bl = isSpaceClear = level.m_8055_(potentialBlockPos).m_60795_() && level.m_8055_(potentialBlockPos.m_7494_()).m_60795_();
            if (!isSpaceClear || (hitResult = level.m_45547_(clipContext = new ClipContext(playerEyePos, potentialSpawnPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player))).m_6662_() != HitResult.Type.MISS) continue;
            return potentialSpawnPos;
        }
        return player.m_146892_();
    }

    public static void playPortalAnimation(ServerPlayer player, MissionItem[] missionItems, int multiplier, int experience, PortalType type) {
        Vec3 spawnPos = Portal.getSafeSpawnPosition(player);
        Portal portal = new Portal((EntityType)EntityInit.PORTAL.get(), player.m_9236_());
        portal.sendMissionMode = false;
        portal.multiplier = multiplier;
        portal.experienceReward = experience;
        portal.targetPlayer = player;
        portal.itemsReward = missionItems;
        portal.setup(missionItems.length, type);
        portal.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        portal.m_7618_(EntityAnchorArgument.Anchor.EYES, player.m_146892_());
        player.m_9236_().m_7967_((Entity)portal);
        portal.m_5496_((SoundEvent)SoundInit.blue_portal_spawn.get(), 0.7f, 1.0f);
    }

    public static void playPortalAnimation(ServerPlayer player, Mission mission, int missionSeed) {
        Vec3 spawnPos = Portal.getSafeSpawnPosition(player);
        Portal portal = new Portal((EntityType)EntityInit.PORTAL.get(), player.m_9236_());
        List<ItemStack> requiredItemsForAnim = Arrays.stream(mission.getRequiredItems(missionSeed)).map(missionItem -> new ItemStack((ItemLike)missionItem.itemStack.m_41720_(), missionItem.number)).toList();
        portal.sendMissionMode = true;
        portal.targetPlayer = player;
        portal.itemsToAnimate = requiredItemsForAnim;
        portal.setup(portal.itemsToAnimate.size(), PortalType.BLUE);
        portal.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        portal.m_7618_(EntityAnchorArgument.Anchor.EYES, player.m_146892_());
        player.m_9236_().m_7967_((Entity)portal);
        portal.m_5496_((SoundEvent)SoundInit.blue_portal_spawn.get(), 0.7f, 1.0f);
    }

    public static void playPortalAnimation(ServerPlayer player, ItemStack itemStack) {
        Vec3 spawnPos = Portal.getSafeSpawnPosition(player);
        Portal portal = new Portal((EntityType)EntityInit.PORTAL.get(), player.m_9236_());
        portal.sendMissionMode = true;
        portal.targetPlayer = player;
        portal.itemsToAnimate = Collections.singletonList(itemStack);
        portal.setup(portal.itemsToAnimate.size(), PortalType.BLUE);
        portal.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        portal.m_7618_(EntityAnchorArgument.Anchor.EYES, player.m_146892_());
        player.m_9236_().m_7967_((Entity)portal);
        portal.m_5496_((SoundEvent)SoundInit.blue_portal_spawn.get(), 0.7f, 1.0f);
    }

    public static enum PortalType {
        BLUE,
        RED;

    }
}

