/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.entity.goal;

import io.github.sluggly.timemercenaries.capability.PetCompanionCapability;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PetGoal {
    public static void attachPetGoals(Mob mob) {
        for (WrappedGoal wrapped : mob.f_21345_.m_148105_().toArray(new WrappedGoal[0])) {
            Goal g = wrapped.m_26015_();
            if (!(g instanceof PanicGoal) && !(g instanceof AvoidEntityGoal)) continue;
            mob.f_21345_.m_25363_(g);
        }
        mob.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedGoalGeneric(mob));
        mob.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoalGeneric(mob, 1.1, 6.0f, 2.0f));
        mob.f_21345_.m_25352_(3, (Goal)new PetMeleeAttackGoal(mob, 1.2, true));
        mob.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoalGeneric(mob));
        mob.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoalGeneric(mob));
        mob.f_21346_.m_25352_(3, (Goal)new IgnoreOwnerHurtByTargetGoal(mob).m_26044_(new Class[0]));
    }

    public static void handleChangeTargetEvent(LivingChangeTargetEvent event) {
        LivingEntity attacker = event.getEntity();
        LivingEntity newTarget = event.getNewTarget();
        if (newTarget == null) {
            return;
        }
        if (Utils.areEntitiesAllied((Entity)attacker, (Entity)newTarget)) {
            event.setNewTarget(null);
            if (attacker instanceof Mob) {
                Mob m = (Mob)attacker;
                m.m_6710_(null);
            }
        }
    }

    public static class SitWhenOrderedGoalGeneric
    extends Goal {
        private final Mob mob;

        public SitWhenOrderedGoalGeneric(Mob mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return PetCompanionCapability.get((Entity)this.mob).map(PetCompanionCapability.IPetCompanion::isSitting).orElse(false);
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
        }
    }

    public static class FollowOwnerGoalGeneric
    extends Goal {
        private final Mob mob;
        private final double speed;
        private final float startDist;
        private final float stopDist;

        public FollowOwnerGoalGeneric(Mob mob, double speed, float startDist, float stopDist) {
            this.mob = mob;
            this.speed = speed;
            this.startDist = startDist;
            this.stopDist = stopDist;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private Player owner() {
            return PetCompanionCapability.get((Entity)this.mob).map(p -> p.getOwner() == null ? null : this.mob.m_9236_().m_46003_(p.getOwner())).orElse(null);
        }

        public boolean m_8036_() {
            Optional<PetCompanionCapability.IPetCompanion> capOpt = PetCompanionCapability.get((Entity)this.mob);
            if (capOpt.isEmpty()) {
                return false;
            }
            PetCompanionCapability.IPetCompanion cap = capOpt.get();
            if (!cap.isPet() || cap.isSitting()) {
                return false;
            }
            Player o = this.owner();
            if (o == null || o.m_5833_()) {
                return false;
            }
            return this.mob.m_20280_((Entity)o) > (double)(this.startDist * this.startDist);
        }

        public boolean m_8045_() {
            Player o = this.owner();
            if (o == null) {
                return false;
            }
            return this.mob.m_20280_((Entity)o) > (double)(this.stopDist * this.stopDist) && PetCompanionCapability.get((Entity)this.mob).map(c -> !c.isSitting()).orElse(false) != false;
        }

        public void m_8037_() {
            Player o = this.owner();
            if (o == null) {
                return;
            }
            this.mob.m_21563_().m_24960_((Entity)o, 10.0f, (float)this.mob.m_8132_());
            if (!this.mob.m_21523_() && !this.mob.m_20159_()) {
                Path path = this.mob.m_21573_().m_6570_((Entity)o, 0);
                if (path != null) {
                    this.mob.m_21573_().m_26536_(path, this.speed);
                } else if (this.mob.m_20280_((Entity)o) > 144.0) {
                    this.tryTeleportNear(o);
                }
            }
        }

        private void tryTeleportNear(Player o) {
            for (int i = 0; i < 10; ++i) {
                int dx = this.mob.m_217043_().m_188503_(7) - 3;
                int dz = this.mob.m_217043_().m_188503_(7) - 3;
                int x = (int)(o.m_20185_() + (double)dx);
                int y = (int)o.m_20186_();
                int z = (int)(o.m_20189_() + (double)dz);
                if (!this.mob.m_9236_().m_45756_((Entity)this.mob, this.mob.m_20191_().m_82386_((double)x - this.mob.m_20185_(), (double)y - this.mob.m_20186_(), (double)z - this.mob.m_20189_()))) continue;
                this.mob.m_6021_((double)x + 0.5, (double)y, (double)z + 0.5);
                this.mob.m_21573_().m_26573_();
                return;
            }
        }
    }

    public static class PetMeleeAttackGoal
    extends MeleeAttackGoal {
        private final Mob mob;

        public PetMeleeAttackGoal(Mob mob, double speedModifier, boolean followWhenNotSeen) {
            super((PathfinderMob)mob, speedModifier, followWhenNotSeen);
            this.mob = mob;
        }

        protected void m_6739_(@NotNull LivingEntity target, double distToEnemySqr) {
            Player p;
            UUID ownerId = PetCompanionCapability.get((Entity)this.mob).map(PetCompanionCapability.IPetCompanion::getOwner).orElse(null);
            if (ownerId != null && target instanceof Player && (p = (Player)target).m_20148_().equals(ownerId)) {
                this.mob.m_6710_(null);
                return;
            }
            double reachSqr = this.m_6639_(target);
            if (distToEnemySqr <= reachSqr && this.m_25565_() <= 0) {
                this.m_25563_();
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                float damage = 1.0f;
                AttributeInstance atk = this.mob.m_21051_(Attributes.f_22281_);
                if (atk != null) {
                    damage = (float)atk.m_22135_();
                } else if (this.mob.getPersistentData().m_128441_("timemercenaries_arena_atk_dmg")) {
                    damage += this.mob.getPersistentData().m_128457_("timemercenaries_arena_atk_dmg");
                }
                target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), damage);
            }
        }

        protected int m_25566_() {
            int interval = 20;
            double aps = 0.0;
            AttributeInstance atkSpd = this.mob.m_21051_(Attributes.f_22283_);
            if (atkSpd != null && atkSpd.m_22135_() > 0.0) {
                aps += atkSpd.m_22135_();
            } else if (this.mob.getPersistentData().m_128441_("timemercenaries_arena_attack_speed")) {
                aps += (double)this.mob.getPersistentData().m_128457_("timemercenaries_arena_attack_speed");
            }
            if (aps > 0.0) {
                interval = (int)Math.round(20.0 / aps);
            }
            return Math.max(5, interval);
        }
    }

    public static class OwnerHurtByTargetGoalGeneric
    extends TargetGoal {
        private Player owner;
        private UUID lastAttackerId;

        public OwnerHurtByTargetGoalGeneric(Mob mob) {
            super(mob, false);
        }

        public boolean m_8036_() {
            this.owner = PetCompanionCapability.get((Entity)this.f_26135_).map(p -> p.getOwner() == null ? null : this.f_26135_.m_9236_().m_46003_(p.getOwner())).orElse(null);
            if (this.owner == null) {
                return false;
            }
            LivingEntity attacker = this.owner.m_21188_();
            if (attacker == null) {
                return false;
            }
            UUID id = attacker.m_20148_();
            if (this.lastAttackerId != null && this.lastAttackerId.equals(id)) {
                return false;
            }
            return this.m_26150_(attacker, TargetingConditions.f_26872_);
        }

        public void m_8056_() {
            LivingEntity attacker = this.owner.m_21188_();
            if (attacker != null) {
                this.f_26135_.m_6710_(attacker);
                this.lastAttackerId = attacker.m_20148_();
                super.m_8056_();
            }
        }
    }

    public static class OwnerHurtTargetGoalGeneric
    extends TargetGoal {
        private Player owner;
        private UUID lastTargetId;

        public OwnerHurtTargetGoalGeneric(Mob mob) {
            super(mob, false);
        }

        public boolean m_8036_() {
            this.owner = PetCompanionCapability.get((Entity)this.f_26135_).map(p -> p.getOwner() == null ? null : this.f_26135_.m_9236_().m_46003_(p.getOwner())).orElse(null);
            if (this.owner == null) {
                return false;
            }
            LivingEntity target = this.owner.m_21214_();
            if (target == null) {
                return false;
            }
            if (!target.m_21224_() && Utils.isEntityFriendly(this.owner, (Entity)target)) {
                this.f_26135_.m_6710_(target);
            }
            UUID id = target.m_20148_();
            if (this.lastTargetId != null && this.lastTargetId.equals(id)) {
                return false;
            }
            return this.m_26150_(target, TargetingConditions.f_26872_);
        }

        public void m_8056_() {
            LivingEntity target = this.owner.m_21214_();
            if (target != null) {
                this.f_26135_.m_6710_(target);
                this.lastTargetId = target.m_20148_();
                super.m_8056_();
            }
        }
    }

    public static class IgnoreOwnerHurtByTargetGoal
    extends HurtByTargetGoal {
        public IgnoreOwnerHurtByTargetGoal(Mob mob) {
            super((PathfinderMob)mob, new Class[0]);
        }

        @Nullable
        private UUID ownerId() {
            return PetCompanionCapability.get((Entity)this.f_26135_).map(PetCompanionCapability.IPetCompanion::getOwner).orElse(null);
        }

        private boolean isOwner(Entity e) {
            Player p;
            UUID oid = this.ownerId();
            return oid != null && e instanceof Player && (p = (Player)e).m_20148_().equals(oid);
        }

        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            LivingEntity last = this.f_26135_.m_21188_();
            Player owner = PetCompanionCapability.get((Entity)this.f_26135_).map(p -> p.getOwner() == null ? null : this.f_26135_.m_9236_().m_46003_(p.getOwner())).orElse(null);
            if (owner == null) {
                return false;
            }
            return last == null || !Utils.isEntityFriendly(owner, (Entity)last) || !this.isOwner((Entity)last);
        }

        public void m_8056_() {
            Player owner = PetCompanionCapability.get((Entity)this.f_26135_).map(p -> p.getOwner() == null ? null : this.f_26135_.m_9236_().m_46003_(p.getOwner())).orElse(null);
            if (owner == null) {
                return;
            }
            LivingEntity last = this.f_26135_.m_21188_();
            if (last != null && this.isOwner((Entity)last) && Utils.isEntityFriendly(owner, (Entity)last)) {
                this.f_26135_.m_6703_(null);
                this.f_26135_.m_6710_(null);
                return;
            }
            super.m_8056_();
        }
    }
}

