/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.entity.projectile;

import io.github.sluggly.timemercenaries.init.EntityInit;
import io.github.sluggly.timemercenaries.item.artefacts.ChainsOfSupremacy;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class ChainProjectile
extends ThrowableItemProjectile {
    public ChainProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ChainProjectile(Level pLevel, LivingEntity pShooter) {
        super((EntityType)EntityInit.CHAIN_PROJECTILE.get(), pShooter, pLevel);
    }

    @NotNull
    protected Item m_7881_() {
        return Items.f_42026_;
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity hitEntity = pResult.m_82443_();
        Entity owner = this.m_19749_();
        if (!this.m_9236_().f_46443_ && owner instanceof Player) {
            LivingEntity livingHit;
            Player player = (Player)owner;
            if (hitEntity instanceof LivingEntity && this.canBeCaptured((Entity)(livingHit = (LivingEntity)hitEntity))) {
                ItemStack heldStack;
                ItemStack itemStack = heldStack = player.m_21205_().m_41720_() instanceof ChainsOfSupremacy ? player.m_21205_() : player.m_21206_();
                if (heldStack.m_41720_() instanceof ChainsOfSupremacy) {
                    ChainsOfSupremacy.captureEntity(heldStack, livingHit);
                    player.m_36335_().m_41524_(heldStack.m_41720_(), 40);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 1.5f);
                    livingHit.m_146870_();
                }
            }
        }
        this.m_146870_();
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        super.m_8060_(pResult);
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    private boolean canBeCaptured(Entity entity) {
        if (entity instanceof Player) {
            return false;
        }
        if (entity instanceof EnderDragon) {
            return false;
        }
        return !(entity instanceof WitherBoss);
    }
}

