/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.events;

import com.mojang.brigadier.CommandDispatcher;
import io.github.sluggly.timemercenaries.admin.AdminCommands;
import io.github.sluggly.timemercenaries.compat.CuriosCompat;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.entity.goal.PetGoal;
import io.github.sluggly.timemercenaries.item.PrimalInfusion;
import io.github.sluggly.timemercenaries.item.artefacts.BeastbinderWand;
import io.github.sluggly.timemercenaries.item.artefacts.CapOfCommerce;
import io.github.sluggly.timemercenaries.item.artefacts.ForgeheartCharm;
import io.github.sluggly.timemercenaries.item.artefacts.GuildBearersSeal;
import io.github.sluggly.timemercenaries.item.artefacts.HeartOfTheMountain;
import io.github.sluggly.timemercenaries.item.artefacts.MantleOfTheGroveWarden;
import io.github.sluggly.timemercenaries.item.artefacts.VoidWovenGreaves;
import io.github.sluggly.timemercenaries.item.artefacts.VolatileConcoctionCasing;
import io.github.sluggly.timemercenaries.lore.Lore;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryManager;
import io.github.sluggly.timemercenaries.missions.MissionManager;
import io.github.sluggly.timemercenaries.module.Module;
import io.github.sluggly.timemercenaries.module.ModuleManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.TradeWithVillagerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="timemercenaries", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerEventHandler {
    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        MercenaryManager.getMercenaryManager().tryProcess();
        MissionManager.getMissionManager().tryProcess();
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        PlayerData.handleAttachCapabilities(event);
    }

    @SubscribeEvent
    public static void onAttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        CuriosCompat.handleAttachCapabilities(event);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerData.handlePlayerDataLoginEvent(event);
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Lore.handleLoreProgressEvent(event);
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        PlayerData.handlePlayerDataCloneEvent(event);
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        AdminCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        HeartOfTheMountain.handleHeartOfTheMountainEffect(event);
    }

    @SubscribeEvent
    public static void onPlayerFall(LivingFallEvent event) {
        VoidWovenGreaves.handleVoidWovenGreavesFallEffect(event);
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            ForgeheartCharm.handleForgeheartCharmEffect(event, player);
        }
        if ((livingEntity = event.getEntity()) instanceof ServerPlayer) {
            player = (ServerPlayer)livingEntity;
            VoidWovenGreaves.handleVoidWovenGreavesVoidEffect(event, (ServerPlayer)player);
            VolatileConcoctionCasing.handleVolatileConcoctionCasingEffect((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)MercenaryManager.getMercenaryManager());
        event.addListener((PreparableReloadListener)ModuleManager.getModuleManager());
        event.addListener((PreparableReloadListener)MissionManager.getMissionManager());
    }

    @SubscribeEvent
    public static void onSleepFinished(SleepFinishedTimeEvent event) {
        Module.handleSleepingModuleEffect(event);
    }

    @SubscribeEvent
    public static void onVillagerTrade(TradeWithVillagerEvent event) {
        CapOfCommerce.handleCapOfCommerceEffect(event);
        GuildBearersSeal.handleGuildBearersSealEffect(event);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        Mercenary.handleRegenerateAllPlayerMercenariesHunger(event);
    }

    @SubscribeEvent
    public static void onPlayerInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        PrimalInfusion.handlePrimalInfusionEffect(event);
        BeastbinderWand.handleBeastbinderWandSitClick(event);
    }

    @SubscribeEvent
    public static void onEquipChanged(LivingEquipmentChangeEvent event) {
        MantleOfTheGroveWarden.handleUnequipEventEffect(event);
    }

    @SubscribeEvent
    public static void onChangeTarget(LivingChangeTargetEvent event) {
        PetGoal.handleChangeTargetEvent(event);
    }
}

