/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public enum ModArmorMaterials implements ArmorMaterial
{
    VOID_WOVEN("void_woven", 37, new int[]{3, 6, 8, 3}, 15, SoundEvents.f_11674_, 3.0f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_})),
    TRADER("trader", 7, new int[]{1, 2, 3, 1}, 25, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42616_})),
    WARDEN("warden", 15, new int[]{2, 4, 6, 2}, 12, SoundEvents.f_11678_, 1.5f, 0.05f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42454_}));

    private final String name;
    private final int durabilityMultiplier;
    private final int[] protectionAmounts;
    private final int enchantmentValue;
    private final SoundEvent equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;
    private static final int[] BASE_DURABILITY;

    private ModArmorMaterials(String name, int durabilityMultiplier, int[] protectionAmounts, int enchantmentValue, SoundEvent equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionAmounts = protectionAmounts;
        this.enchantmentValue = enchantmentValue;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    public int m_266425_(ArmorItem.Type pType) {
        return BASE_DURABILITY[pType.m_266308_().m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type pType) {
        return this.protectionAmounts[pType.m_266308_().m_20749_()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    @NotNull
    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    @NotNull
    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    @NotNull
    public String m_6082_() {
        return "timemercenaries:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        BASE_DURABILITY = new int[]{13, 15, 16, 11};
    }
}

