/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item;

import com.google.common.collect.Multimap;
import io.github.sluggly.timemercenaries.item.artefacts.BeastbinderWand;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimalInfusion
extends Item {
    public static final UUID PRIMAL_INFUSION_UPGRADE_UUID = UUID.fromString("e625a381-8b7b-4d2d-ab27-8f32e369c2d9");
    public static final String PRIMAL_INFUSION_UPGRADE_NAME = "Primal Infusion";

    public PrimalInfusion(Item.Properties pProperties) {
        super(pProperties);
    }

    public void applyEffect(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity) {
        TamableAnimal tamable;
        Level level = player.m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_() && tamable.m_21830_((LivingEntity)player) || BeastbinderWand.isMobBound(player, (Mob)entity)) {
            Multimap modifiers = stack.m_41638_(EquipmentSlot.OFFHAND);
            if (modifiers.isEmpty()) {
                player.m_213846_((Component)Component.m_237113_((String)"This infusion is inert.").m_130940_(ChatFormatting.RED));
                return;
            }
            PrimalInfusion.clearAll(entity);
            for (Map.Entry entry : modifiers.entries()) {
                Attribute attribute = (Attribute)entry.getKey();
                AttributeModifier originalModifier = (AttributeModifier)entry.getValue();
                AttributeInstance attributeInstance = entity.m_21051_(attribute);
                if (attributeInstance != null) {
                    AttributeModifier permanentModifier = new AttributeModifier(PRIMAL_INFUSION_UPGRADE_UUID, PRIMAL_INFUSION_UPGRADE_NAME, originalModifier.m_22218_(), originalModifier.m_22217_());
                    attributeInstance.m_22125_(permanentModifier);
                    continue;
                }
                Utils.setCustomAttribute((Mob)entity, (Attribute)entry.getKey(), originalModifier.m_22218_());
            }
            entity.m_21153_(entity.m_21233_());
            level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            level.m_5594_(null, entity.m_20183_(), SoundEvents.f_144243_, SoundSource.PLAYERS, 1.0f, 1.2f);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            player.m_213846_((Component)Component.m_237113_((String)(entity.m_7755_().getString() + " has been permanently empowered!")).m_130940_(ChatFormatting.GREEN));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"This can only be used on your tamed pets.").m_130940_(ChatFormatting.YELLOW));
        }
    }

    public static void clearAll(LivingEntity mob) {
        AttributeInstance inst;
        AttributeMap attributeMap = mob.m_21204_();
        if (attributeMap.m_22154_(Attributes.f_22281_, PRIMAL_INFUSION_UPGRADE_UUID) && (inst = mob.m_21051_(Attributes.f_22281_)) != null) {
            inst.m_22120_(PRIMAL_INFUSION_UPGRADE_UUID);
        }
        if (attributeMap.m_22154_(Attributes.f_22284_, PRIMAL_INFUSION_UPGRADE_UUID) && (inst = mob.m_21051_(Attributes.f_22284_)) != null) {
            inst.m_22120_(PRIMAL_INFUSION_UPGRADE_UUID);
        }
        if (attributeMap.m_22154_(Attributes.f_22285_, PRIMAL_INFUSION_UPGRADE_UUID) && (inst = mob.m_21051_(Attributes.f_22285_)) != null) {
            inst.m_22120_(PRIMAL_INFUSION_UPGRADE_UUID);
        }
        if (attributeMap.m_22154_(Attributes.f_22276_, PRIMAL_INFUSION_UPGRADE_UUID) && (inst = mob.m_21051_(Attributes.f_22276_)) != null) {
            inst.m_22120_(PRIMAL_INFUSION_UPGRADE_UUID);
        }
        if (attributeMap.m_22154_(Attributes.f_22279_, PRIMAL_INFUSION_UPGRADE_UUID) && (inst = mob.m_21051_(Attributes.f_22279_)) != null) {
            inst.m_22120_(PRIMAL_INFUSION_UPGRADE_UUID);
        }
        if (attributeMap.m_22154_(Attributes.f_22283_, PRIMAL_INFUSION_UPGRADE_UUID) && (inst = mob.m_21051_(Attributes.f_22283_)) != null) {
            inst.m_22120_(PRIMAL_INFUSION_UPGRADE_UUID);
        }
        if (attributeMap.m_22154_(Attributes.f_22278_, PRIMAL_INFUSION_UPGRADE_UUID) && (inst = mob.m_21051_(Attributes.f_22278_)) != null) {
            inst.m_22120_(PRIMAL_INFUSION_UPGRADE_UUID);
        }
        if (attributeMap.m_22154_(Attributes.f_22282_, PRIMAL_INFUSION_UPGRADE_UUID) && (inst = mob.m_21051_(Attributes.f_22282_)) != null) {
            inst.m_22120_(PRIMAL_INFUSION_UPGRADE_UUID);
        }
        if (attributeMap.m_22154_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), PRIMAL_INFUSION_UPGRADE_UUID) && (inst = mob.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get())) != null) {
            inst.m_22120_(PRIMAL_INFUSION_UPGRADE_UUID);
        }
        Utils.removeCustomAttribute((Mob)mob);
    }

    public static void handlePrimalInfusionEffect(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        ItemStack heldStack = event.getItemStack();
        Item item = heldStack.m_41720_();
        if (item instanceof PrimalInfusion) {
            PrimalInfusion primalInfusion = (PrimalInfusion)item;
            if (event.getTarget() instanceof TamableAnimal || BeastbinderWand.isMobBound(player, (Mob)event.getTarget())) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                if (player.m_9236_().m_5776_()) {
                    return;
                }
                primalInfusion.applyEffect(heldStack, player, (LivingEntity)event.getTarget());
            }
        }
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.primal_infusion.effect").m_130940_(ChatFormatting.GOLD));
    }
}

