/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import io.github.sluggly.timemercenaries.compat.CuriosCompat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiceOfInfinitePossibilities
extends Item {
    private static final int COOLDOWN_TICKS = 18000;
    private static final List<Consumer<ServerPlayer>> POSSIBLE_EVENTS = new ArrayList<Consumer<ServerPlayer>>();

    public DiceOfInfinitePossibilities(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack heldStack = pPlayer.m_21120_(pUsedHand);
        if (!pLevel.f_46443_ && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            if (POSSIBLE_EVENTS.isEmpty()) {
                return InteractionResultHolder.m_19100_((Object)heldStack);
            }
            pPlayer.m_36335_().m_41524_((Item)this, 18000);
            pLevel.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_12644_, SoundSource.PLAYERS, 1.0f, 2.0f);
            Consumer<ServerPlayer> randomEvent = POSSIBLE_EVENTS.get(pLevel.f_46441_.m_188503_(POSSIBLE_EVENTS.size()));
            randomEvent.accept(serverPlayer);
        }
        return InteractionResultHolder.m_19092_((Object)heldStack, (boolean)pLevel.m_5776_());
    }

    private static void eventGiveDiamonds(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"The dice clatters and reveals a shimmering fortune!").m_130940_(ChatFormatting.GREEN));
        ItemEntity diamondDrop = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)Items.f_42415_, 3));
        player.m_9236_().m_7967_((Entity)diamondDrop);
    }

    private static void eventSpawnEnemies(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"An ominous rattle... you are not alone anymore.").m_130940_(ChatFormatting.RED));
        for (int i = 0; i < 4; ++i) {
            Zombie zombie = (Zombie)EntityType.f_20501_.m_20615_(player.m_9236_());
            if (zombie == null) continue;
            BlockPos spawnPos = player.m_20183_().m_7918_(-3 + player.m_217043_().m_188503_(7), 0, -3 + player.m_217043_().m_188503_(7));
            zombie.m_6034_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
            zombie.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
            player.m_9236_().m_7967_((Entity)zombie);
        }
    }

    private static void eventTeleportRandomly(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"The world twists and reforms around you!").m_130940_(ChatFormatting.YELLOW));
        for (int i = 0; i < 16; ++i) {
            double x = player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * 16.0;
            double y = player.m_20186_() + (double)(player.m_217043_().m_188503_(16) - 8);
            double z = player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * 16.0;
            if (player.m_20159_()) {
                player.m_8127_();
            }
            BlockPos targetPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            if (!player.m_9236_().m_8055_(targetPos).m_60647_((BlockGetter)player.m_9236_(), targetPos, PathComputationType.LAND)) continue;
            player.m_6021_(x, y, z);
            player.f_19789_ = 0.0f;
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_146850_(GameEvent.f_238175_);
            return;
        }
    }

    private static void eventRainOfFish(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"The air suddenly smells... fishy.").m_130940_(ChatFormatting.AQUA));
        for (int i = 0; i < 10; ++i) {
            ItemEntity fish = new ItemEntity(player.m_9236_(), player.m_20185_() - 3.0 + (double)player.m_217043_().m_188503_(7), player.m_20186_() + 10.0 + (double)player.m_217043_().m_188503_(5), player.m_20189_() - 3.0 + (double)player.m_217043_().m_188503_(7), new ItemStack((ItemLike)Items.f_42526_));
            player.m_9236_().m_7967_((Entity)fish);
        }
    }

    private static void eventMinorCurse(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"You feel a sudden, draining weakness.").m_130940_(ChatFormatting.RED));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 600, 0));
    }

    private static void eventGrantExperience(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"You feel a surge of ancient knowledge!").m_130940_(ChatFormatting.GREEN));
        player.m_6749_(30);
    }

    private static void eventDrainExperience(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"You feel your knowledge and experience draining away...").m_130940_(ChatFormatting.RED));
        player.m_9174_(0);
        player.m_8985_(0);
    }

    private static void eventRepairAllItems(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"A wave of restorative energy flows through your gear!").m_130940_(ChatFormatting.GOLD));
        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11671_, SoundSource.PLAYERS, 0.5f, 1.5f);
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!stack.m_41763_()) continue;
            stack.m_41721_(0);
        }
        for (ItemStack stack : player.m_150109_().f_35975_) {
            if (!stack.m_41763_()) continue;
            stack.m_41721_(0);
        }
        for (ItemStack stack : player.m_150109_().f_35976_) {
            if (!stack.m_41763_()) continue;
            stack.m_41721_(0);
        }
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.repairAllEquippedCurios(player);
        }
    }

    private static void eventSpawnMysticTrader(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"A mysterious figure appears, offering a once-in-a-lifetime deal...").m_130940_(ChatFormatting.AQUA));
        WanderingTrader trader = (WanderingTrader)EntityType.f_20494_.m_20615_(player.m_9236_());
        if (trader != null) {
            MerchantOffer specialOffer = new MerchantOffer(new ItemStack((ItemLike)Items.f_42329_, 1), new ItemStack((ItemLike)Items.f_42415_, 10), Integer.MAX_VALUE, 0, 0.0f);
            MerchantOffers offers = trader.m_6616_();
            offers.clear();
            offers.add((Object)specialOffer);
            trader.m_6593_((Component)Component.m_237113_((String)"Mystic Trader").m_130940_(ChatFormatting.LIGHT_PURPLE));
            trader.m_35891_(200);
            trader.m_146884_(player.m_20182_());
            player.m_9236_().m_7967_((Entity)trader);
        }
    }

    private static void eventGravityShift(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"The world turns upside down!").m_130940_(ChatFormatting.YELLOW));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 100, 0));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 0));
    }

    private static void eventSuddenHunger(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"A gnawing emptiness consumes your stomach...").m_130940_(ChatFormatting.RED));
        player.m_36324_().m_38705_(0);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 600, 0));
    }

    private static void eventPhantomStep(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"You fade into the shadows, your steps quickened.").m_130940_(ChatFormatting.GREEN));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 600, 0));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 1));
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.dice_of_infinite_possibilities.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.dice_of_infinite_possibilities.flavor").m_130940_(ChatFormatting.DARK_PURPLE));
    }

    static {
        POSSIBLE_EVENTS.add(DiceOfInfinitePossibilities::eventGiveDiamonds);
        POSSIBLE_EVENTS.add(DiceOfInfinitePossibilities::eventSpawnEnemies);
        POSSIBLE_EVENTS.add(DiceOfInfinitePossibilities::eventTeleportRandomly);
        POSSIBLE_EVENTS.add(DiceOfInfinitePossibilities::eventRainOfFish);
        POSSIBLE_EVENTS.add(DiceOfInfinitePossibilities::eventMinorCurse);
        POSSIBLE_EVENTS.add(DiceOfInfinitePossibilities::eventGrantExperience);
        POSSIBLE_EVENTS.add(DiceOfInfinitePossibilities::eventDrainExperience);
        POSSIBLE_EVENTS.add(DiceOfInfinitePossibilities::eventRepairAllItems);
        POSSIBLE_EVENTS.add(DiceOfInfinitePossibilities::eventSpawnMysticTrader);
        POSSIBLE_EVENTS.add(DiceOfInfinitePossibilities::eventGravityShift);
        POSSIBLE_EVENTS.add(DiceOfInfinitePossibilities::eventSuddenHunger);
        POSSIBLE_EVENTS.add(DiceOfInfinitePossibilities::eventPhantomStep);
    }
}

