/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import io.github.sluggly.timemercenaries.compat.CuriosCompat;
import io.github.sluggly.timemercenaries.init.ItemInit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeheartCharm
extends Item {
    public ForgeheartCharm(Item.Properties pProperties) {
        super(pProperties);
    }

    private void charmTick(Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        if (player.m_20077_()) {
            player.m_7311_(0);
            if (player.f_19797_ % 20 == 0) {
                ArrayList<ItemStack> itemsToRepair = new ArrayList<ItemStack>();
                if (player.m_21205_().m_41763_()) {
                    itemsToRepair.add(player.m_21205_());
                }
                if (player.m_21206_().m_41763_()) {
                    itemsToRepair.add(player.m_21206_());
                }
                player.m_150109_().f_35975_.forEach(itemStack -> {
                    if (itemStack.m_41763_()) {
                        itemsToRepair.add((ItemStack)itemStack);
                    }
                });
                for (ItemStack repairable : itemsToRepair) {
                    if (repairable.m_41773_() <= 0) continue;
                    repairable.m_41721_(Math.max(0, repairable.m_41773_() - 5));
                }
            }
        }
    }

    public void m_6883_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        Player player;
        if (pEntity instanceof Player && ForgeheartCharm.isItemEquipped(player = (Player)pEntity)) {
            this.charmTick(pLevel, player);
        }
    }

    private static boolean isItemEquipped(Player player) {
        if (player.m_21205_().m_150930_((Item)ItemInit.FORGEHEART_CHARM.get()) || player.m_21206_().m_150930_((Item)ItemInit.FORGEHEART_CHARM.get())) {
            return true;
        }
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.hasItemEquippedAsCurio(player, (Item)ItemInit.FORGEHEART_CHARM.get());
        }
        return false;
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.forgeheart_charm.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.forgeheart_charm.flavor").m_130940_(ChatFormatting.GRAY));
    }

    public static void handleForgeheartCharmEffect(LivingHurtEvent event, Player player) {
        boolean hasCharm;
        if ((event.getSource().m_276093_(DamageTypes.f_268631_) || event.getSource().m_276093_(DamageTypes.f_268546_) || event.getSource().m_276093_(DamageTypes.f_268468_)) && (hasCharm = ForgeheartCharm.isItemEquipped(player)) && player.m_20077_()) {
            event.setCanceled(true);
        }
    }
}

