/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GolemancersCore
extends Item {
    private static final int COOLDOWN_TICKS = 1400;
    private static final String TAG_INFUSION_COUNT = "HestraInfusionCount";

    public GolemancersCore(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack coreStack = pPlayer.m_21120_(pUsedHand);
        return this.summonGolem(pLevel, pPlayer, coreStack);
    }

    private InteractionResultHolder<ItemStack> summonGolem(Level pLevel, Player pPlayer, ItemStack pStack) {
        if (!pLevel.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            InfusedIronGolem golem = new InfusedIronGolem((EntityType<? extends IronGolem>)EntityType.f_20460_, (Level)serverLevel);
            golem.m_6034_(pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_());
            golem.m_28887_(true);
            int infusionCount = GolemancersCore.getInfusionCount(pStack);
            AttributeInstance healthAttribute = golem.m_21051_(Attributes.f_22276_);
            if (healthAttribute != null) {
                healthAttribute.m_22100_((double)golem.m_21233_() + (double)infusionCount * 2.0);
                golem.m_21153_(golem.m_21233_());
            }
            serverLevel.m_7967_((Entity)golem);
            pLevel.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_12009_, SoundSource.PLAYERS, 1.0f, 1.0f);
            pPlayer.m_36335_().m_41524_((Item)this, 1400);
        }
        return InteractionResultHolder.m_19092_((Object)pStack, (boolean)pLevel.m_5776_());
    }

    public static int getInfusionCount(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TAG_INFUSION_COUNT)) {
            return tag.m_128451_(TAG_INFUSION_COUNT);
        }
        return 0;
    }

    public static void setInfusionCount(ItemStack stack, int count) {
        stack.m_41784_().m_128405_(TAG_INFUSION_COUNT, count);
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return GolemancersCore.getInfusionCount(pStack) > 0;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.golemancers_core.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.golemancers_core.flavor").m_130940_(ChatFormatting.GRAY));
        int infusionCount = GolemancersCore.getInfusionCount(pStack);
        pTooltipComponents.add((Component)Component.m_237113_((String)"Infusion Level: ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)String.valueOf(infusionCount)).m_130940_(ChatFormatting.YELLOW)));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Golem Health Bonus: ").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)("+" + infusionCount + " Hearts")).m_130940_(ChatFormatting.RED)));
    }

    public static class InfusedIronGolem
    extends IronGolem {
        private int lifeTicks = 1200;

        public InfusedIronGolem(EntityType<? extends IronGolem> pEntityType, Level pLevel) {
            super(pEntityType, pLevel);
        }

        public void m_8107_() {
            super.m_8107_();
            if (!this.m_9236_().f_46443_) {
                --this.lifeTicks;
                if (this.lifeTicks <= 0) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11937_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 20, 0.5, 1.0, 0.5, 0.0);
                    this.m_146870_();
                }
            }
        }

        protected void m_7472_(@NotNull DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        }
    }
}

