/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import io.github.sluggly.timemercenaries.entity.projectile.GoldenOrbProjectile;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeartOfTheMountain
extends Item {
    private static final String TAG_STORED_ORE_STATE = "StoredOreState";
    private static final int MAX_RANGE = 60;
    private static final int COOLDOWN_TICKS = 400;
    public static final TagKey<Block> ORES = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("forge", "ores"));

    public HeartOfTheMountain(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack heldStack = pPlayer.m_21120_(pUsedHand);
        if (!pLevel.f_46443_) {
            Optional<BlockState> storedOreState = HeartOfTheMountain.getStoredOre((HolderGetter<Block>)pLevel.m_246945_(Registries.f_256747_), heldStack);
            if (storedOreState.isEmpty()) {
                pPlayer.m_6330_(SoundEvents.f_11797_, SoundSource.PLAYERS, 1.0f, 1.5f);
                return InteractionResultHolder.m_19100_((Object)heldStack);
            }
            this.findClosestOre(pLevel, pPlayer, storedOreState.get()).ifPresentOrElse(targetPos -> {
                GoldenOrbProjectile orb = new GoldenOrbProjectile(pLevel, (LivingEntity)pPlayer);
                orb.m_146884_(pPlayer.m_146892_());
                orb.shootTowards((BlockPos)targetPos);
                pLevel.m_7967_((Entity)orb);
                pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_144243_, SoundSource.PLAYERS, 1.0f, 1.0f);
                pPlayer.m_36335_().m_41524_((Item)this, 400);
            }, () -> {
                pPlayer.m_6330_(SoundEvents.f_11797_, SoundSource.PLAYERS, 1.0f, 1.0f);
                pPlayer.m_36335_().m_41524_((Item)this, 400);
            });
        }
        return InteractionResultHolder.m_19092_((Object)heldStack, (boolean)pLevel.m_5776_());
    }

    public static void handleHeartOfTheMountainEffect(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack heldStack = player.m_21205_();
        if (!(heldStack.m_41720_() instanceof HeartOfTheMountain)) {
            heldStack = player.m_21206_();
        }
        if (!(heldStack.m_41720_() instanceof HeartOfTheMountain)) {
            return;
        }
        BlockState brokenState = event.getState();
        if (brokenState.m_204336_(ORES)) {
            HeartOfTheMountain.setStoredOre(heldStack, brokenState);
            player.m_6330_((SoundEvent)SoundEvents.f_12216_.get(), SoundSource.PLAYERS, 1.0f, 1.5f);
        }
    }

    private Optional<BlockPos> findClosestOre(Level level, Player player, BlockState targetState) {
        return BlockPos.m_121930_((BlockPos)player.m_20183_(), (int)60, (int)60, pos -> level.m_8055_(pos).equals(targetState));
    }

    public static void setStoredOre(ItemStack stack, BlockState oreState) {
        if (stack.m_41720_() instanceof HeartOfTheMountain) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128365_(TAG_STORED_ORE_STATE, (Tag)NbtUtils.m_129202_((BlockState)oreState));
        }
    }

    public static Optional<BlockState> getStoredOre(HolderGetter<Block> pBlockHolderGetter, ItemStack stack) {
        if (!stack.m_41782_() || !Objects.requireNonNull(stack.m_41783_()).m_128441_(TAG_STORED_ORE_STATE)) {
            return Optional.empty();
        }
        return Optional.of(NbtUtils.m_247651_(pBlockHolderGetter, (CompoundTag)stack.m_41783_().m_128469_(TAG_STORED_ORE_STATE)));
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        if (!pStack.m_41782_()) {
            return false;
        }
        assert (pStack.m_41783_() != null);
        return pStack.m_41783_().m_128441_(TAG_STORED_ORE_STATE);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.heart_of_the_mountain.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.heart_of_the_mountain.flavor").m_130940_(ChatFormatting.GRAY));
        if (pLevel != null) {
            HeartOfTheMountain.getStoredOre((HolderGetter<Block>)pLevel.m_246945_(Registries.f_256747_), pStack).ifPresentOrElse(state -> pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.timemercenaries.heart_of_the_mountain.tracking", (Object[])new Object[]{state.m_60734_().m_49954_()}).m_130940_(ChatFormatting.AQUA)), () -> pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.heart_of_the_mountain.empty").m_130940_(ChatFormatting.DARK_GRAY)));
        }
    }
}

