/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import io.github.sluggly.timemercenaries.init.EffectInit;
import io.github.sluggly.timemercenaries.init.ItemInit;
import io.github.sluggly.timemercenaries.item.ModArmorMaterials;
import io.github.sluggly.timemercenaries.item.artefacts.BeastbinderWand;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MantleOfTheGroveWarden
extends ArmorItem {
    private static final int CHECK_INTERVAL_TICKS = 600;
    private static final int BUFF_DURATION_TICKS = 620;
    private static final int SCAN_RADIUS = 10;
    private static final int MAX_PETS = 10;

    public MantleOfTheGroveWarden(Item.Properties props) {
        super((ArmorMaterial)ModArmorMaterials.WARDEN, ArmorItem.Type.CHESTPLATE, props);
    }

    public void m_6883_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pLevel.m_5776_() || !(pEntity instanceof Player)) {
            return;
        }
        Player player = (Player)pEntity;
        if (player.f_19797_ % 600 == 0) {
            if (player.m_6844_(EquipmentSlot.CHEST) != pStack) {
                return;
            }
            int petCount = MantleOfTheGroveWarden.countOwnedPetsNearby(player, 10.0);
            if (petCount > 0) {
                player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.SYMBIOSIS.get(), 620, petCount - 1, true, false, true));
            }
        }
    }

    public static int countOwnedPetsNearby(Player player, double radius) {
        AABB box = player.m_20191_().m_82400_(radius);
        List list = player.m_9236_().m_6443_(LivingEntity.class, box, e -> e.m_6084_() && e != player && MantleOfTheGroveWarden.isOwnedByPlayer((Entity)e, player));
        return Math.min(list.size(), 10);
    }

    public static boolean isOwnedByPlayer(Entity e, Player player) {
        TamableAnimal t;
        if (e instanceof TamableAnimal && (t = (TamableAnimal)e).m_21824_() && t.m_21830_((LivingEntity)player)) {
            return true;
        }
        return BeastbinderWand.isMobBound(player, (Mob)e);
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.mantle_of_the_grove_warden.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.mantle_of_the_grove_warden.flavor").m_130940_(ChatFormatting.GREEN));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public static void handleUnequipEventEffect(LivingEquipmentChangeEvent event) {
        boolean isMantle;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (event.getSlot() != EquipmentSlot.CHEST) {
            return;
        }
        ItemStack from = event.getFrom();
        ItemStack to = event.getTo();
        boolean wasMantle = from.m_41720_() == ItemInit.MANTLE_OF_THE_GROVE_WARDEN.get();
        boolean bl = isMantle = to.m_41720_() == ItemInit.MANTLE_OF_THE_GROVE_WARDEN.get();
        if (wasMantle && !isMantle) {
            player.m_21195_((MobEffect)EffectInit.SYMBIOSIS.get());
        }
    }
}

