/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import io.github.sluggly.timemercenaries.entity.ThrownPrimalSpear;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimalHuntingSpear
extends Item {
    private static final String STACK_COUNT_KEY = "timemercenaries_SpearHitCount";

    public PrimalHuntingSpear(Item.Properties pProperties) {
        super(pProperties);
    }

    public static int getSpearHitCount(LivingEntity entity) {
        if (entity.getPersistentData().m_128441_(STACK_COUNT_KEY)) {
            return entity.getPersistentData().m_128451_(STACK_COUNT_KEY);
        }
        return 0;
    }

    public static void incrementSpearHitCount(LivingEntity entity) {
        int currentCount = PrimalHuntingSpear.getSpearHitCount(entity);
        entity.getPersistentData().m_128405_(STACK_COUNT_KEY, currentCount + 1);
    }

    public boolean m_7579_(@NotNull ItemStack pStack, @NotNull LivingEntity pTarget, LivingEntity pAttacker) {
        int stacks = PrimalHuntingSpear.getSpearHitCount(pTarget);
        float bonusDamage = (float)stacks * 0.5f;
        pTarget.m_6469_(pAttacker.m_269291_().m_269333_(pAttacker), bonusDamage);
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 72000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)pPlayer.m_21120_(pHand));
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pEntityLiving, int pTimeLeft) {
        if (!(pEntityLiving instanceof Player)) {
            return;
        }
        Player player = (Player)pEntityLiving;
        int chargeDuration = this.m_8105_(pStack) - pTimeLeft;
        if (chargeDuration < 5) {
            return;
        }
        float charge = (float)chargeDuration / 20.0f;
        if ((charge = (charge * charge + charge * 2.0f) / 3.0f) > 1.0f) {
            charge = 1.0f;
        }
        if (!pLevel.f_46443_) {
            ThrownPrimalSpear spear = new ThrownPrimalSpear(pLevel, (LivingEntity)player, pStack);
            spear.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, charge * 2.5f, 1.0f);
            spear.setDamage(charge * 5.0f);
            if (charge >= 1.0f) {
                spear.m_36762_(true);
            }
            pLevel.m_7967_((Entity)spear);
        }
        pLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public boolean m_8120_(@NotNull ItemStack pStack) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 15;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44988_ || enchantment == Enchantments.f_44989_ || enchantment == Enchantments.f_44990_ || enchantment == Enchantments.f_44961_ || enchantment == Enchantments.f_44956_ || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.primal_hunting_spear.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.primal_hunting_spear.flavor").m_130940_(ChatFormatting.GOLD));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

