/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RiftInABottle
extends Item {
    private static final String TAG_ANCHOR_POS = "RiftAnchorPos";
    private static final String TAG_ANCHOR_DIM = "RiftAnchorDim";
    private static final int XP_COST_TELEPORT = 10;
    private static final int COOLDOWN_ANCHOR = 6000;
    private static final int COOLDOWN_TELEPORT = 24000;

    public RiftInABottle(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        Level level = pContext.m_43725_();
        ItemStack stack = pContext.m_43722_();
        if (player != null && player.m_36341_()) {
            if (!level.f_46443_) {
                BlockPos anchorPos = pContext.m_8083_().m_7494_();
                ResourceLocation dimensionId = level.m_46472_().m_135782_();
                CompoundTag tag = stack.m_41784_();
                tag.m_128365_(TAG_ANCHOR_POS, (Tag)NbtUtils.m_129224_((BlockPos)anchorPos));
                tag.m_128359_(TAG_ANCHOR_DIM, dimensionId.toString());
                player.m_213846_((Component)Component.m_237113_((String)"Rift anchored to your location.").m_130940_(ChatFormatting.LIGHT_PURPLE));
                player.m_36335_().m_41524_((Item)this, 6000);
            }
            level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.2f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack heldStack = pPlayer.m_21120_(pUsedHand);
        if (pPlayer.m_36341_()) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        if (!pLevel.f_46443_) {
            CompoundTag tag = heldStack.m_41783_();
            if (tag == null || !tag.m_128441_(TAG_ANCHOR_POS)) {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"This rift is not anchored to a location.").m_130940_(ChatFormatting.RED));
                return InteractionResultHolder.m_19100_((Object)heldStack);
            }
            if (!pPlayer.m_7500_()) {
                if (pPlayer.f_36078_ < 10) {
                    pPlayer.m_213846_((Component)Component.m_237113_((String)"Not enough experience levels.").m_130940_(ChatFormatting.RED));
                    return InteractionResultHolder.m_19100_((Object)heldStack);
                }
                if (!pPlayer.m_150109_().m_18949_(Set.of(Items.f_42584_))) {
                    pPlayer.m_213846_((Component)Component.m_237113_((String)"Requires an Ender Pearl.").m_130940_(ChatFormatting.RED));
                    return InteractionResultHolder.m_19100_((Object)heldStack);
                }
            }
            this.performTeleport((ServerPlayer)pPlayer, tag);
            if (!pPlayer.m_7500_()) {
                pPlayer.m_6749_(-10);
                pPlayer.m_150109_().m_36022_(p -> p.m_150930_(Items.f_42584_), 1, (Container)pPlayer.m_150109_());
            }
            pPlayer.m_36335_().m_41524_((Item)this, 24000);
        }
        return InteractionResultHolder.m_19092_((Object)heldStack, (boolean)pLevel.m_5776_());
    }

    private void performTeleport(ServerPlayer player, CompoundTag tag) {
        Level level;
        BlockPos anchorPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(TAG_ANCHOR_POS));
        ResourceKey anchorDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_(TAG_ANCHOR_DIM)));
        if (player.m_9236_().m_46472_() == anchorDim && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            player.m_8999_(serverLevel, (double)anchorPos.m_123341_() + 0.5, (double)anchorPos.m_123342_(), (double)anchorPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
        } else {
            ServerLevel targetLevel = Objects.requireNonNull(player.m_20194_()).m_129880_(anchorDim);
            if (targetLevel != null) {
                player.m_8999_(targetLevel, (double)anchorPos.m_123341_() + 0.5, (double)anchorPos.m_123342_(), (double)anchorPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
            }
        }
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_146850_(GameEvent.f_238175_);
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        if (!pStack.m_41782_()) {
            return false;
        }
        assert (pStack.m_41783_() != null);
        return pStack.m_41783_().m_128441_(TAG_ANCHOR_POS);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.rift_in_a_bottle.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.rift_in_a_bottle.flavor").m_130940_(ChatFormatting.DARK_PURPLE));
        if (pStack.m_41782_() && Objects.requireNonNull(pStack.m_41783_()).m_128441_(TAG_ANCHOR_POS)) {
            CompoundTag tag = pStack.m_41783_();
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(TAG_ANCHOR_POS));
            String dim = tag.m_128461_(TAG_ANCHOR_DIM);
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.timemercenaries.rift_in_a_bottle.anchored", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), dim}).m_130940_(ChatFormatting.AQUA));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.rift_in_a_bottle.unanchored").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }
}

