/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import io.github.sluggly.timemercenaries.compat.CuriosCompat;
import io.github.sluggly.timemercenaries.init.ItemInit;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TalismanOfTheWilds
extends Item {
    private static final int CHECK_INTERVAL_TICKS = 500;
    private static final int BUFF_DURATION_TICKS = 600;
    private static final int WOLF_DETECTION_RANGE = 16;

    public TalismanOfTheWilds(Item.Properties pProperties) {
        super(pProperties);
    }

    private void applyEffect(Player player) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (player.f_19797_ % 500 != 0) {
            return;
        }
        AABB searchArea = player.m_20191_().m_82400_(16.0);
        boolean ownedWolfIsNearby = player.m_9236_().m_6443_(Wolf.class, searchArea, wolf -> wolf.m_21824_() && wolf.m_21830_((LivingEntity)player)).stream().findAny().isPresent();
        if (ownedWolfIsNearby) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600, 2, false, false, true));
        }
    }

    public void m_6883_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        Player player;
        if (pEntity instanceof Player && TalismanOfTheWilds.isItemEquipped(player = (Player)pEntity)) {
            this.applyEffect(player);
        }
    }

    private static boolean isItemEquipped(Player player) {
        if (player.m_21205_().m_150930_((Item)ItemInit.TALISMAN_OF_THE_WILDS.get()) || player.m_21206_().m_150930_((Item)ItemInit.TALISMAN_OF_THE_WILDS.get())) {
            return true;
        }
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.hasItemEquippedAsCurio(player, (Item)ItemInit.TALISMAN_OF_THE_WILDS.get());
        }
        return false;
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.talisman_of_the_wilds.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.talisman_of_the_wilds.flavor").m_130940_(ChatFormatting.GREEN));
    }
}

