/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThunderInABottle
extends Item {
    private static final int COOLDOWN = 100;

    public ThunderInABottle(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack heldStack = pPlayer.m_21120_(pUsedHand);
        if (!pLevel.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            AABB areaOfEffect = new AABB(pPlayer.m_20183_()).m_82400_(10.0);
            List nearbyEntities = pLevel.m_45976_(LivingEntity.class, areaOfEffect);
            this.spawnLightning(serverLevel, pPlayer.m_20183_());
            for (LivingEntity entity : nearbyEntities) {
                if (entity == pPlayer) continue;
                this.spawnLightning(serverLevel, entity.m_20183_());
            }
            pPlayer.m_36335_().m_41524_((Item)this, 100);
            pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12521_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.m_19090_((Object)heldStack);
    }

    private void spawnLightning(ServerLevel level, BlockPos pos) {
        EntityType.f_20465_.m_262496_(level, pos, MobSpawnType.TRIGGERED);
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.thunder_in_a_bottle.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.thunder_in_a_bottle.flavor").m_130940_(ChatFormatting.YELLOW));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

