/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import io.github.sluggly.timemercenaries.init.ItemInit;
import io.github.sluggly.timemercenaries.item.ModArmorMaterials;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoidWovenLeggings
extends ArmorItem {
    public static int COOLDOWN = 40;
    private static boolean wasJumping = false;

    public VoidWovenLeggings(Item.Properties pProperties) {
        super((ArmorMaterial)ModArmorMaterials.VOID_WOVEN, ArmorItem.Type.LEGGINGS, pProperties);
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.void_woven_leggings.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.void_woven_leggings.flavor").m_130940_(ChatFormatting.DARK_PURPLE));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public static void performVoidJump(ServerPlayer player) {
        ServerLevel level = player.m_284548_();
        Vec3 look = player.m_20154_();
        double distance = 8.0;
        for (int i = 0; i < 16; ++i) {
            BlockPos targetPos;
            double targetX = player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * 4.0 + look.f_82479_ * distance;
            double targetY = player.m_20186_() + (double)(player.m_217043_().m_188503_(16) - 8);
            double targetZ = player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * 4.0 + look.f_82481_ * distance;
            targetY = Mth.m_14008_((double)targetY, (double)level.m_141937_(), (double)(level.m_141937_() + level.m_143344_() - 1));
            if (player.m_20159_()) {
                player.m_8127_();
            }
            if (!level.m_8055_(targetPos = BlockPos.m_274561_((double)targetX, (double)targetY, (double)targetZ)).m_60647_((BlockGetter)level, targetPos, PathComputationType.LAND)) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, player.m_20185_(), player.m_20186_() + (double)player.m_20206_() * 0.5, player.m_20189_(), 20, 0.5, 0.5, 0.5, 0.0);
            player.m_6021_(targetX, targetY, targetZ);
            player.f_19789_ = 0.0f;
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, player.m_20185_(), player.m_20186_() + (double)player.m_20206_() * 0.5, player.m_20189_(), 20, 0.5, 0.5, 0.5, 0.0);
            return;
        }
        player.m_6330_(SoundEvents.f_11797_, SoundSource.PLAYERS, 1.0f, 1.2f);
    }

    public static void handleClientVoidJump(Minecraft mc) {
        boolean isJumping = mc.f_91066_.f_92089_.m_90857_();
        if (isJumping && wasJumping) {
            assert (mc.f_91074_ != null);
            if (!(mc.f_91074_.m_20096_() || mc.f_91074_.m_150110_().f_35935_ || mc.f_91074_.m_6069_() || mc.f_91074_.m_20159_() || !mc.f_91074_.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemInit.VOID_WOVEN_LEGGINGS.get()))) {
                PacketHandler.sendToServer("VoidJump");
            }
        }
        wasJumping = isJumping;
    }

    public static void playerVoidJump(ServerPlayer player) {
        if (!(!player.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemInit.VOID_WOVEN_LEGGINGS.get()) || player.m_20096_() || player.m_150110_().f_35935_ || player.m_6069_() || player.m_20159_() || player.m_36335_().m_41519_((Item)ItemInit.VOID_WOVEN_LEGGINGS.get()))) {
            VoidWovenLeggings.performVoidJump(player);
            player.m_36335_().m_41524_((Item)ItemInit.VOID_WOVEN_LEGGINGS.get(), COOLDOWN);
        }
    }
}

