/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.lore;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.init.ItemInit;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class Lore {
    public static Map<Float, String> mapProgressStep = new LinkedHashMap<Float, String>();

    public static CompoundTag getPlayerLoreTag(PlayerData playerData) {
        return playerData.playerDataTag.m_128469_("Lore");
    }

    public static float getPlayerLoreProgress(PlayerData playerData) {
        CompoundTag loreTag = Lore.getPlayerLoreTag(playerData);
        return loreTag.m_128457_("Progress");
    }

    public static int getPlayerLoreCount(PlayerData playerData) {
        CompoundTag loreTag = Lore.getPlayerLoreTag(playerData);
        return loreTag.m_128451_("Count");
    }

    public static void setPlayerLoreCount(PlayerData playerData, int count) {
        CompoundTag loreTag = Lore.getPlayerLoreTag(playerData);
        loreTag.m_128405_("Count", count);
    }

    public static void setPlayerLoreProgress(PlayerData playerData, float progress) {
        CompoundTag loreTag = Lore.getPlayerLoreTag(playerData);
        loreTag.m_128350_("Progress", progress);
    }

    public static float getPlayerNextLoreProgress(PlayerData playerData) {
        float currentProgress = Lore.getPlayerLoreProgress(playerData);
        boolean found = false;
        for (Map.Entry<Float, String> entry : mapProgressStep.entrySet()) {
            if (found) {
                return entry.getKey().floatValue();
            }
            if (!entry.getKey().equals(Float.valueOf(currentProgress))) continue;
            found = true;
        }
        return currentProgress;
    }

    public static void setPlayerNextLoreProgress(PlayerData playerData) {
        float nextProgress = Lore.getPlayerNextLoreProgress(playerData);
        Lore.setPlayerLoreProgress(playerData, nextProgress);
    }

    public static void completeLoreStep(ServerPlayer player) {
        PlayerData playerData;
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Received complete lore step request from player : " + player.m_6302_());
        }
        if ((playerData = PlayerData.getPlayerData((Player)player)) == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        float progress = Lore.getPlayerLoreProgress(playerData);
        if (progress == 0.0f) {
            if (Utils.hasEnoughItems(Items.f_42451_, (Player)player, 10)) {
                Utils.removeItemInInventory(Items.f_42451_, 10, (Player)player);
                Lore.setPlayerNextLoreProgress(playerData);
                PacketHandler.sendToPlayer("RefreshData", playerData, player);
            } else {
                Admin.playerRequestError((Player)player, "Attempted to complete lore step 0.0 without required items.");
            }
        } else if (progress == 0.1f) {
            if (player.m_20186_() >= 200.0 && player.m_9236_().m_46472_() == Level.f_46428_) {
                Lore.setPlayerNextLoreProgress(playerData);
                PacketHandler.sendToPlayer("RefreshData", playerData, player);
            } else {
                Admin.playerRequestError((Player)player, "Attempted to complete lore step 0.1 without meeting conditions.");
            }
        } else if (progress == 0.2f) {
            if (player.m_20186_() < 0.0 && player.m_9236_().m_46472_() == Level.f_46428_) {
                Lore.setPlayerNextLoreProgress(playerData);
                PacketHandler.sendToPlayer("RefreshData", playerData, player);
            } else {
                Admin.playerRequestError((Player)player, "Attempted to complete lore step 0.2 without meeting conditions.");
            }
        } else if (progress == 0.3f) {
            if (player.m_5842_()) {
                Lore.setPlayerNextLoreProgress(playerData);
                PacketHandler.sendToPlayer("RefreshData", playerData, player);
            } else {
                Admin.playerRequestError((Player)player, "Attempted to complete lore step 0.3 without meeting conditions.");
            }
        } else if (progress == 0.4f) {
            CompoundTag loreTag = Lore.getPlayerLoreTag(playerData);
            if (loreTag.m_128451_("Count") >= 3) {
                Lore.setPlayerNextLoreProgress(playerData);
                PacketHandler.sendToPlayer("RefreshData", playerData, player);
            } else {
                Admin.playerRequestError((Player)player, "Attempted to complete lore step 0.4 without meeting conditions.");
            }
        } else if (progress == 0.5f) {
            if (Utils.hasEnoughItems(Items.f_42516_, (Player)player, 1)) {
                Utils.removeItemInInventory(Items.f_42516_, 1, (Player)player);
                Lore.setPlayerNextLoreProgress(playerData);
                PacketHandler.sendToPlayer("OpenRecruitScreen", playerData, player);
            } else {
                Admin.playerRequestError((Player)player, "Attempted to complete lore step 0.5 without required items.");
            }
        }
    }

    public static void handleLoreProgressEvent(LivingDeathEvent event) {
        ServerPlayer player;
        PlayerData playerData;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer && (playerData = PlayerData.getPlayerData((Player)(player = (ServerPlayer)entity))) != null && Lore.getPlayerLoreProgress(playerData) == 0.4f) {
            CompoundTag loreTag;
            int currentKills;
            boolean isHoldingClock;
            boolean bl = isHoldingClock = player.m_21205_().m_150930_((Item)ItemInit.DIMENSIONAL_TIME_CLOCK.get()) || player.m_21206_().m_150930_((Item)ItemInit.DIMENSIONAL_TIME_CLOCK.get());
            if (isHoldingClock && (currentKills = (loreTag = Lore.getPlayerLoreTag(playerData)).m_128451_("Count")) < 3) {
                loreTag.m_128405_("Count", currentKills + 1);
                PacketHandler.sendToPlayer("RefreshData", playerData, player);
            }
        }
    }

    static {
        mapProgressStep.put(Float.valueOf(0.0f), "Tutorial Start: Power Up Clock");
        mapProgressStep.put(Float.valueOf(0.1f), "Tutorial Step 2: High Altitude Signal");
        mapProgressStep.put(Float.valueOf(0.2f), "Tutorial Step 3: Deep World Resonance");
        mapProgressStep.put(Float.valueOf(0.3f), "Tutorial Step 4: Quench The Thirst");
        mapProgressStep.put(Float.valueOf(0.4f), "Tutorial Step 5: Blood Offering");
        mapProgressStep.put(Float.valueOf(0.5f), "Tutorial Step 6: The Contract");
        mapProgressStep.put(Float.valueOf(1.0f), "Tutorial End");
    }
}

