/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.mercenary;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.Quest;
import io.github.sluggly.timemercenaries.mercenary.Shopkeeper;
import io.github.sluggly.timemercenaries.mercenary.Trait;
import io.github.sluggly.timemercenaries.missions.Mission;
import io.github.sluggly.timemercenaries.module.Module;
import io.github.sluggly.timemercenaries.utils.NBTKeys;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class MercenaryPlayerData {
    public static void generateAndAttachBaseMercenaryCompoundTag(PlayerData playerData, CompoundTag playerDataTag) {
        if (playerDataTag.m_128441_("State")) {
            playerDataTag.m_128473_("State");
        }
        playerDataTag.m_128359_("State", "Recruiting");
        if (playerDataTag.m_128441_("CurrentMercenary")) {
            playerDataTag.m_128473_("CurrentMercenary");
        }
        playerDataTag.m_128359_("CurrentMercenary", "None");
        if (playerDataTag.m_128441_("Mercenaries")) {
            playerDataTag.m_128473_("Mercenaries");
        }
        CompoundTag mercenaries = new CompoundTag();
        for (String mercenaryName : Mercenary.getMercenariesName()) {
            MercenaryPlayerData.addNewMercenaryToTag(playerData, mercenaryName, mercenaries);
        }
        playerDataTag.m_128365_("Mercenaries", (Tag)mercenaries);
        if (Mercenary.getMercenariesName().size() >= 3) {
            MercenaryPlayerData.generateRecruitsForPlayer(playerData);
        }
    }

    public static void addNewMercenaryToTag(PlayerData playerData, String mercenaryName, CompoundTag mercenariesTag) {
        Mercenary mercenary = Mercenary.getMercenary(mercenaryName);
        if (mercenary == null) {
            return;
        }
        CompoundTag tmpMercenary = new CompoundTag();
        tmpMercenary.m_128405_("Exp", 0);
        if (mercenaryName.equals("Vael")) {
            tmpMercenary.m_128405_("Coins", 0);
            byte[] byteArray = new byte[Shopkeeper.maxItems];
            tmpMercenary.m_128365_("ShopStatus", (Tag)new ByteArrayTag(byteArray));
            CompoundTag availableQuests = new CompoundTag();
            for (int i = 1; i <= playerData.getNumberOfQuests(); ++i) {
                availableQuests.m_128365_("Quest" + i, (Tag)MercenaryPlayerData.getEmptyMercenaryQuestTag());
            }
            tmpMercenary.m_128365_("QuestsAvailable", (Tag)availableQuests);
            tmpMercenary.m_128359_("ChosenQuest", "None");
            tmpMercenary.m_128359_("QuestStatus", "None");
            tmpMercenary.m_128359_("MissionStatus", "None");
            tmpMercenary.m_128405_("TotalTime", 0);
            tmpMercenary.m_128405_("TimeLeft", 0);
        } else {
            tmpMercenary.m_128379_("Totem", false);
            CompoundTag tmpTraits = new CompoundTag();
            for (Map.Entry<String, Trait> entry : Trait.getTraitsMap()) {
                tmpTraits.m_128405_(entry.getKey(), 0);
            }
            tmpMercenary.m_128365_("Traits", (Tag)tmpTraits);
            tmpMercenary.m_128405_("CurrentHealth", mercenary.health);
            tmpMercenary.m_128405_("MaxHealth", mercenary.health);
            tmpMercenary.m_128405_("Hunger", 10);
            tmpMercenary.m_128379_("Fed", false);
            tmpMercenary.m_128405_("LevelsSpent", 0);
            tmpMercenary.m_128359_("ChosenMission", NBTKeys.MISSION_EMPTY_ID.toString());
            tmpMercenary.m_128405_("TotalTime", 0);
            tmpMercenary.m_128405_("TimeLeft", 0);
            tmpMercenary.m_128379_("Bribed", false);
            tmpMercenary.m_128359_("MissionStatus", "None");
            CompoundTag missionsAvailableTag = new CompoundTag();
            for (int i = 1; i <= playerData.getNumberOfMissions(); ++i) {
                CompoundTag tmpMission = MercenaryPlayerData.getEmptyMercenaryMissionTag();
                missionsAvailableTag.m_128365_("Mission" + i, (Tag)tmpMission);
            }
            tmpMercenary.m_128365_("MissionsAvailable", (Tag)missionsAvailableTag);
        }
        tmpMercenary.m_128405_("Reroll", 0);
        tmpMercenary.m_128405_("Seed", Utils.generateSeed());
        tmpMercenary.m_128365_("Statistics", (Tag)MercenaryPlayerData.getEmptyStatisticsTag(mercenaryName.equals("Vael")));
        mercenariesTag.m_128365_(mercenary.name, (Tag)tmpMercenary);
    }

    public static void generateRecruitsForPlayer(PlayerData playerData) {
        Random random = new Random();
        int numberOfRecruits = MercenaryPlayerData.getNumberOfRecruits();
        HashSet<String> recruits = new HashSet<String>();
        for (String mercenaryName : Mercenary.getMercenariesName()) {
            if (!MercenaryPlayerData.isMercenaryBribed(playerData, mercenaryName)) continue;
            recruits.add(mercenaryName);
        }
        while (recruits.size() < numberOfRecruits) {
            String mercenaryName = Mercenary.getMercenariesName().get(random.nextInt(Mercenary.getMercenariesName().size()));
            if (!MercenaryPlayerData.isMercenaryUnlocked(playerData, mercenaryName)) continue;
            recruits.add(mercenaryName);
        }
        int index = 1;
        CompoundTag recruitsAvailable = new CompoundTag();
        for (String mercenaryName : recruits) {
            MercenaryPlayerData.generateMercenaryNewSeed(playerData, mercenaryName);
            MercenaryPlayerData.resetMercenaryMissionReroll(playerData, mercenaryName);
            MercenaryPlayerData.setMercenaryBribe(playerData, mercenaryName, false);
            recruitsAvailable.m_128359_("Recruit" + index++, mercenaryName);
        }
        playerData.playerDataTag.m_128365_("RecruitsAvailable", (Tag)recruitsAvailable);
    }

    public static CompoundTag getMercenaryQuestsTag(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128469_("QuestsAvailable");
    }

    public static CompoundTag getMercenaryQuestTagByIndex(PlayerData playerData, String mercenaryName, int questIndex) {
        CompoundTag questsTag = MercenaryPlayerData.getMercenaryQuestsTag(playerData, mercenaryName);
        return questsTag.m_128469_("Quest" + questIndex);
    }

    public static CompoundTag getMercenaryChosenQuestTag(PlayerData playerData, String mercenaryName) {
        int questIndex = MercenaryPlayerData.getMercenaryChosenQuestIndex(playerData, mercenaryName);
        return MercenaryPlayerData.getMercenaryQuestTagByIndex(playerData, mercenaryName, questIndex);
    }

    public static String getMercenaryChosenQuestObjectiveId(PlayerData playerData, String mercenaryName) {
        return MercenaryPlayerData.getMercenaryChosenQuestTag(playerData, mercenaryName).m_128461_("RequirementId");
    }

    public static String getMercenaryChosenQuestRewardId(PlayerData playerData, String mercenaryName) {
        return MercenaryPlayerData.getMercenaryChosenQuestTag(playerData, mercenaryName).m_128461_("RewardId");
    }

    public static int getMercenaryChosenQuestIndex(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128451_("ChosenQuest");
    }

    public static String getMercenaryQuestStatus(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128461_("QuestStatus");
    }

    public static void setMercenaryChosenQuestIndex(PlayerData playerData, String mercenaryName, int questIndex) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("ChosenQuest", questIndex);
        mercenaryTag.m_128359_("QuestStatus", "Ongoing");
    }

    public static void cleanMercenaryChosenQuest(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("ChosenQuest", 0);
        mercenaryTag.m_128359_("QuestStatus", "None");
    }

    public static void rerollMercenaryShop(PlayerData playerData, String mercenaryName) {
        MercenaryPlayerData.generateMercenaryNewSeed(playerData, mercenaryName);
        MercenaryPlayerData.resetShopkeeperItemsStatus(playerData, mercenaryName);
    }

    public static void rerollMercenaryQuest(PlayerData playerData, String mercenaryName, int index) {
        CompoundTag questsTag = MercenaryPlayerData.getMercenaryQuestsTag(playerData, mercenaryName);
        questsTag.m_128365_("Quest" + index, (Tag)MercenaryPlayerData.generateMercenaryQuest());
    }

    public static CompoundTag getMercenariesTag(PlayerData playerData) {
        return playerData.playerDataTag.m_128469_("Mercenaries");
    }

    public static CompoundTag getMercenaryTraitsTag(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128469_("Traits");
    }

    public static int getMercenarySeed(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128451_("Seed");
    }

    public static String getCurrentMercenary(PlayerData playerData) {
        return playerData.playerDataTag.m_128461_("CurrentMercenary");
    }

    public static void setCurrentMercenary(PlayerData playerData, String mercenaryName) {
        playerData.playerDataTag.m_128359_("CurrentMercenary", mercenaryName);
    }

    public static void setMercenaryMissionsAvailable(PlayerData playerData, String mercenaryName, List<ResourceLocation> missionIds) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        CompoundTag missionsAvailableTag = mercenaryTag.m_128469_("MissionsAvailable");
        for (int i = 0; i < missionIds.size(); ++i) {
            String missionId = "Mission" + (i + 1);
            CompoundTag mission = missionsAvailableTag.m_128469_(missionId);
            mission.m_128359_("Id", missionIds.get(i).toString());
        }
    }

    public static List<ResourceLocation> getMercenaryMissionsAvailable(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        CompoundTag missionsAvailableTag = mercenaryTag.m_128469_("MissionsAvailable");
        ArrayList<ResourceLocation> missionIds = new ArrayList<ResourceLocation>();
        for (String missionNumber : missionsAvailableTag.m_128431_()) {
            CompoundTag missionTag = missionsAvailableTag.m_128469_(missionNumber);
            String missionId = missionTag.m_128461_("Id");
            missionIds.add(new ResourceLocation(missionId));
        }
        return missionIds;
    }

    public static ArrayList<Integer> getMercenaryMissionsDifficulty(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        CompoundTag missionsAvailableTag = mercenaryTag.m_128469_("MissionsAvailable");
        ArrayList<Integer> missionDifficulties = new ArrayList<Integer>();
        for (String missionNumber : missionsAvailableTag.m_128431_()) {
            missionDifficulties.add(missionsAvailableTag.m_128469_(missionNumber).m_128451_("Difficulty"));
        }
        return missionDifficulties;
    }

    public static boolean isMercenaryMissionAvailable(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        List<ResourceLocation> missions = MercenaryPlayerData.getMercenaryMissionsAvailable(playerData, mercenaryName);
        return missions.contains(missionId);
    }

    public static void setMercenaryMissionTimeLeft(PlayerData playerData, String mercenaryName, int time) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("TimeLeft", time);
    }

    public static int getMercenaryMissionTimeLeft(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128451_("TimeLeft");
    }

    public static int getMercenaryMissionTimeTotal(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128451_("TotalTime");
    }

    public static void setMercenaryMissionTimes(PlayerData playerData, String mercenaryName, int time) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("TotalTime", time);
        mercenaryTag.m_128405_("TimeLeft", time);
    }

    public static void setMercenaryMissionStatus(PlayerData playerData, String mercenaryName, String status) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128359_("MissionStatus", status);
    }

    public static String getMercenaryMissionStatus(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128461_("MissionStatus");
    }

    public static void setMercenaryChosenMission(PlayerData playerData, String mercenaryName, String missionId) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128359_("ChosenMission", missionId);
    }

    public static void cleanMercenaryChosenMission(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128359_("ChosenMission", NBTKeys.MISSION_EMPTY_ID.toString());
    }

    public static ResourceLocation getMercenaryChosenMission(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return new ResourceLocation(mercenaryTag.m_128461_("ChosenMission"));
    }

    public static CompoundTag getRecruitsAvailableTag(PlayerData playerData) {
        return playerData.playerDataTag.m_128469_("RecruitsAvailable");
    }

    public static String[] getRecruitsAvailable(PlayerData playerData) {
        CompoundTag recruitsAvailable = MercenaryPlayerData.getRecruitsAvailableTag(playerData);
        String[] recruits = new String[recruitsAvailable.m_128440_()];
        int index = 0;
        for (String key : recruitsAvailable.m_128431_()) {
            recruits[index++] = recruitsAvailable.m_128461_(key);
        }
        return recruits;
    }

    public static boolean isMercenaryBribed(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128471_("Bribed");
    }

    public static void setMercenaryBribe(PlayerData playerData, String mercenaryName, boolean bool) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128379_("Bribed", bool);
        if (bool) {
            MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "Bribe");
        }
    }

    public static int getMercenaryTraitLevel(PlayerData playerData, String mercenaryName, String traitName) {
        CompoundTag traitsTag = MercenaryPlayerData.getMercenaryTraitsTag(playerData, mercenaryName);
        return traitsTag.m_128451_(traitName);
    }

    public static int getNumberOfRecruits() {
        return 3;
    }

    public static int getMercenaryLevel(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return Mercenary.getLevel(mercenaryTag.m_128451_("Exp"));
    }

    public static int getMercenaryExp(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128451_("Exp");
    }

    public static void setMercenaryExp(PlayerData playerData, String mercenaryName, int exp) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("Exp", exp);
    }

    public static void healMercenaryPercent(PlayerData playerData, String mercenaryName, int percent) {
        int maxHealth = MercenaryPlayerData.getMercenaryMaxHealth(playerData, mercenaryName);
        int currentHealth = MercenaryPlayerData.getMercenaryCurrentHealth(playerData, mercenaryName);
        int heal = (int)((double)maxHealth * (double)percent / 100.0);
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("CurrentHealth", Math.min(maxHealth, currentHealth + heal));
    }

    public static void healMercenary(PlayerData playerData, String mercenaryName, int heal) {
        int maxHealth = MercenaryPlayerData.getMercenaryMaxHealth(playerData, mercenaryName);
        int currentHealth = MercenaryPlayerData.getMercenaryCurrentHealth(playerData, mercenaryName);
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("CurrentHealth", Math.min(maxHealth, currentHealth + heal));
    }

    public static void healMercenaryFull(PlayerData playerData, String mercenaryName) {
        int maxHealth = MercenaryPlayerData.getMercenaryMaxHealth(playerData, mercenaryName);
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("CurrentHealth", maxHealth);
    }

    public static void mercenaryLevelUpPerks(PlayerData playerData, String mercenaryName) {
        MercenaryPlayerData.healMercenaryFull(playerData, mercenaryName);
        MercenaryPlayerData.setMercenaryHunger(playerData, mercenaryName, MercenaryPlayerData.getMercenaryMaximumHunger(playerData, mercenaryName));
    }

    public static void mercenaryGainMissionExp(PlayerData playerData, String mercenaryName, int originalExp, int difficulty) {
        int totalExp = MercenaryPlayerData.getMercenaryMissionUpdatedExperience(playerData, mercenaryName, originalExp, difficulty);
        MercenaryPlayerData.mercenaryGainExp(playerData, mercenaryName, totalExp);
    }

    public static void mercenaryGainExp(PlayerData playerData, String mercenaryName, int exp) {
        int originalLevel = MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName);
        int currentExp = MercenaryPlayerData.getMercenaryExp(playerData, mercenaryName);
        MercenaryPlayerData.setMercenaryExp(playerData, mercenaryName, currentExp + exp);
        int newLevel = MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName);
        if (originalLevel < newLevel) {
            MercenaryPlayerData.mercenaryLevelUpPerks(playerData, mercenaryName);
        }
    }

    public static boolean doesMercenaryScavengerTraitProc(PlayerData playerData, String mercenaryName) {
        int randomLevel = MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenaryName, "Scavenger");
        return (MercenaryPlayerData.getMercenarySeed(playerData, mercenaryName) + 1337) % 100 >= 100 - randomLevel;
    }

    public static boolean doesMercenaryProcurerTraitProc(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        int procurerLevel = MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenaryName, "Procurer");
        if (procurerLevel <= 0) {
            return false;
        }
        int chanceThreshold = procurerLevel * 5;
        int missionSeed = MercenaryPlayerData.getMercenaryMissionSeed(playerData, mercenaryName, missionId);
        int roll = (missionSeed + 81632) % 1000;
        return roll < chanceThreshold;
    }

    public static int getMercenaryMissionUpdatedExperience(PlayerData playerData, String mercenaryName, int experience, int difficulty) {
        int experienceLevel = MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenaryName, "Knowledgeable");
        return (int)((double)experience * (1.0 + 0.25 * (double)experienceLevel) * (double)(1 + difficulty * 3));
    }

    public static int getMercenaryMissionUpdatedFailChance(PlayerData playerData, String mercenaryName, int missionFailChance, int difficulty) {
        int failLevel = MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenaryName, "Reliable");
        return missionFailChance + difficulty * 50 - failLevel;
    }

    public static int getMercenaryMissionUpdatedTime(PlayerData playerData, String mercenaryName, int time, int difficulty) {
        int speedLevel = MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenaryName, "Speed");
        return (int)((double)(time + time * difficulty + difficulty * 120) / ((100.0 + 10.0 * (double)speedLevel) / 100.0));
    }

    public static int getMercenaryMissionUpdatedDamages(int damages, int difficulty) {
        if (difficulty == 1) {
            return damages * 2 + 15;
        }
        if (difficulty == 2) {
            return damages * 4 + 40;
        }
        return damages;
    }

    public static int getMercenaryScavengerTraitValue(PlayerData playerData, String mercenaryName) {
        int chosenTrait = 0;
        int index = 0;
        boolean isMaxLevel = true;
        while (isMaxLevel) {
            chosenTrait = (MercenaryPlayerData.getMercenarySeed(playerData, mercenaryName) + 1337 + index) % Trait.getTraits().size();
            isMaxLevel = MercenaryPlayerData.isMercenaryTraitMaximumLevel(playerData, mercenaryName, Trait.getTrait((int)chosenTrait).name);
            ++index;
        }
        return chosenTrait;
    }

    public static boolean doesMercenaryHaveTotem(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128471_("Totem");
    }

    public static void manualMercenaryTraitLevelUp(PlayerData playerData, String mercenaryName, String trait) {
        MercenaryPlayerData.increaseMercenaryTraitLevel(playerData, mercenaryName, trait);
        MercenaryPlayerData.setMercenaryLevelsSpent(playerData, mercenaryName, MercenaryPlayerData.getMercenaryLevelsSpent(playerData, mercenaryName) + 1);
    }

    public static void setMercenaryMaxHealth(PlayerData playerData, String mercenaryName, int maxHealth) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("MaxHealth", maxHealth);
    }

    public static void recalculateMercenaryMaxHealth(PlayerData playerData, String mercenaryName) {
        int maxHealth = Mercenary.getMercenary((String)mercenaryName).health;
        MercenaryPlayerData.setMercenaryMaxHealth(playerData, mercenaryName, maxHealth += MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenaryName, "Sturdiness") / 2);
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        int currentHealth = mercenaryTag.m_128451_("CurrentHealth");
        currentHealth = Math.min(currentHealth, maxHealth);
        mercenaryTag.m_128405_("CurrentHealth", currentHealth);
    }

    public static void increaseMercenaryTraitLevel(PlayerData playerData, String mercenaryName, String trait) {
        int traitLevel = MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenaryName, trait);
        MercenaryPlayerData.getMercenaryTraitsTag(playerData, mercenaryName).m_128405_(trait, traitLevel + 1);
        if (trait.equals("Sturdiness")) {
            int oldMaxHealth = MercenaryPlayerData.getMercenaryMaxHealth(playerData, mercenaryName);
            MercenaryPlayerData.recalculateMercenaryMaxHealth(playerData, mercenaryName);
            int newMaxHealth = MercenaryPlayerData.getMercenaryMaxHealth(playerData, mercenaryName);
            if (oldMaxHealth < newMaxHealth) {
                MercenaryPlayerData.healMercenary(playerData, mercenaryName, newMaxHealth - oldMaxHealth);
            }
        }
    }

    public static void setMercenaryTraitLevel(PlayerData playerData, String mercenaryName, String trait, int level) {
        CompoundTag traitTag = MercenaryPlayerData.getMercenaryTraitsTag(playerData, mercenaryName);
        traitTag.m_128405_(trait, level);
    }

    public static void setMercenaryTotem(PlayerData playerData, String mercenaryName, boolean bool) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128379_("Totem", bool);
        if (!bool) {
            MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "Totem");
        }
    }

    public static int getMercenaryLevelsSpent(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128451_("LevelsSpent");
    }

    public static void setMercenaryLevelsSpent(PlayerData playerData, String mercenaryName, int levels) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("LevelsSpent", levels);
    }

    public static boolean isMercenaryUnlocked(PlayerData playerData, String mercenaryName) {
        Mercenary mercenary = Mercenary.getMercenary(mercenaryName);
        if (mercenary.moduleRequirement != null) {
            return Module.isModuleActive(playerData, mercenary.moduleRequirement);
        }
        return true;
    }

    public static void removeAvailableRecruit(PlayerData playerData, String mercenaryName) {
        CompoundTag recruitsAvailable = MercenaryPlayerData.getRecruitsAvailableTag(playerData);
        for (String key : recruitsAvailable.m_128431_()) {
            if (!recruitsAvailable.m_128461_(key).equals(mercenaryName)) continue;
            recruitsAvailable.m_128359_(key, "None");
        }
    }

    public static void generateRecruitsIfNecessary(PlayerData playerData) {
        CompoundTag recruitsAvailable = MercenaryPlayerData.getRecruitsAvailableTag(playerData);
        if (recruitsAvailable.m_128456_()) {
            MercenaryPlayerData.generateRecruitsForPlayer(playerData);
        } else {
            HashSet<String> recruits = new HashSet<String>();
            int numberOfRecruits = MercenaryPlayerData.getNumberOfRecruits();
            for (String key : recruitsAvailable.m_128431_()) {
                String mercenaryName = recruitsAvailable.m_128461_(key);
                if (mercenaryName.equals("None") || recruits.contains(mercenaryName)) continue;
                --numberOfRecruits;
                recruits.add(mercenaryName);
                MercenaryPlayerData.setMercenaryFed(playerData, mercenaryName, false);
            }
            if (numberOfRecruits > 0) {
                for (String mercenaryName : Mercenary.getMercenariesName()) {
                    if (!MercenaryPlayerData.isMercenaryBribed(playerData, mercenaryName) || recruits.contains(mercenaryName)) continue;
                    --numberOfRecruits;
                    recruits.add(mercenaryName);
                    MercenaryPlayerData.generateMercenaryNewSeed(playerData, mercenaryName);
                    MercenaryPlayerData.setMercenaryBribe(playerData, mercenaryName, false);
                    MercenaryPlayerData.setMercenaryFed(playerData, mercenaryName, false);
                }
                Random random = new Random();
                while (numberOfRecruits > 0) {
                    String mercenaryName;
                    mercenaryName = Mercenary.getMercenariesName().get(random.nextInt(Mercenary.getMercenariesName().size()));
                    if (!MercenaryPlayerData.isMercenaryUnlocked(playerData, mercenaryName) || recruits.contains(mercenaryName)) continue;
                    --numberOfRecruits;
                    recruits.add(mercenaryName);
                    MercenaryPlayerData.generateMercenaryNewSeed(playerData, mercenaryName);
                    MercenaryPlayerData.setMercenaryBribe(playerData, mercenaryName, false);
                    MercenaryPlayerData.setMercenaryFed(playerData, mercenaryName, false);
                }
                int index = 1;
                for (String mercenaryName : recruits) {
                    recruitsAvailable.m_128359_("Recruit" + index++, mercenaryName);
                }
            }
        }
    }

    public static int getMercenaryLootMultiplier(PlayerData playerData, String mercenaryName) {
        int doubleLevel = MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenaryName, "Greedy");
        int doubleChance = 100 - 5 * doubleLevel;
        int multiplier = 1;
        if (doubleChance < 100 && MercenaryPlayerData.getMercenarySeed(playerData, mercenaryName) % 100 >= doubleChance) {
            multiplier = 2;
        }
        return multiplier;
    }

    public static int getMercenaryMissionDifficultyMultiplier(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        int multiplier = 1;
        int difficultyIndex = MercenaryPlayerData.getMercenaryMissionDifficultyIndex(playerData, mercenaryName, missionId);
        if (difficultyIndex == 1) {
            multiplier = 2;
        } else if (difficultyIndex == 2) {
            multiplier = 3 + MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName) / 5;
        }
        return multiplier;
    }

    public static int getMercenaryMissionTotalMultiplier(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        return MercenaryPlayerData.getMercenaryLootMultiplier(playerData, mercenaryName) * MercenaryPlayerData.getMercenaryMissionDifficultyMultiplier(playerData, mercenaryName, missionId);
    }

    public static void generateMissionsForMercenary(PlayerData playerData, String mercenaryName) {
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Generating Missions for : " + mercenaryName);
        }
        Mercenary mercenary = Mercenary.getMercenary(mercenaryName);
        int levelRecruit = MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName);
        int[] missionProbability = Mission.getMissionsProbability(levelRecruit);
        int numberOfMissions = playerData.getNumberOfMissions();
        HashSet<ResourceLocation> missionsSet = new HashSet<ResourceLocation>();
        while (missionsSet.size() < numberOfMissions) {
            missionsSet.add(mercenary.getRandomMissionId(missionProbability));
        }
        ArrayList<ResourceLocation> missionsList = new ArrayList<ResourceLocation>(missionsSet);
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Missions generated : " + String.valueOf(missionsList));
        }
        MercenaryPlayerData.setMercenaryMissionsAvailable(playerData, mercenaryName, missionsList);
        MercenaryPlayerData.generateMercenaryNewMissionsSeed(playerData, mercenaryName);
    }

    public static void generateMissionsForMercenaryIfNecessary(PlayerData playerData, String mercenaryName) {
        List<ResourceLocation> missions = MercenaryPlayerData.getMercenaryMissionsAvailable(playerData, mercenaryName);
        if (!missions.get(0).toString().equals(NBTKeys.MISSION_EMPTY_ID.toString())) {
            return;
        }
        MercenaryPlayerData.generateMissionsForMercenary(playerData, mercenaryName);
        MercenaryPlayerData.generateMercenaryNewMissionsSeed(playerData, mercenaryName);
    }

    public static ResourceLocation generateSingleMissionForMercenary(PlayerData playerData, String mercenaryName) {
        Mercenary mercenary = Mercenary.getMercenary(mercenaryName);
        int levelRecruit = MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName);
        int[] missionProbability = Mission.getMissionsProbability(levelRecruit);
        return mercenary.getRandomMissionId(missionProbability);
    }

    public static ResourceLocation generateSingleMissionRarityForMercenary(String mercenaryName, String rarity) {
        Mercenary mercenary = Mercenary.getMercenary(mercenaryName);
        int[] missionProbability = new int[Mission.mapRarityIndex.size()];
        missionProbability[Mission.mapRarityIndex.get((Object)rarity).intValue()] = 100;
        return mercenary.getRandomMissionId(missionProbability);
    }

    public static void rerollMercenaryMission(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        CompoundTag mercenaryData = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        List<ResourceLocation> missions = MercenaryPlayerData.getMercenaryMissionsAvailable(playerData, mercenaryName);
        int indexMission = 0;
        for (ResourceLocation mission : missions) {
            if (mission.toString().equals(missionId.toString())) break;
            ++indexMission;
        }
        ResourceLocation newMissionId = null;
        if (indexMission < missions.size()) {
            while (missions.get(indexMission).toString().equals(missionId.toString())) {
                newMissionId = MercenaryPlayerData.generateSingleMissionForMercenary(playerData, mercenaryName);
                if (newMissionId.toString().equals(missionId.toString()) || MercenaryPlayerData.isMercenaryMissionAvailable(playerData, mercenaryName, newMissionId)) continue;
                missions.set(indexMission, newMissionId);
                if (!Admin.ADMIN_SERVER_CONSOLE_LOG) continue;
                System.out.println("Re-rolling Mission: " + String.valueOf(missionId) + " to new Mission: " + String.valueOf(newMissionId));
            }
        } else {
            return;
        }
        int rerollsLeft = MercenaryPlayerData.getMercenaryMissionRerollLeft(playerData, mercenaryName);
        mercenaryData.m_128405_("Reroll", rerollsLeft - 1);
        MercenaryPlayerData.setMercenaryMissionsAvailable(playerData, mercenaryName, missions);
        MercenaryPlayerData.generateMercenaryNewMissionSeed(playerData, mercenaryName, newMissionId);
    }

    public static void sameRerollMercenaryMission(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        CompoundTag mercenaryData = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        List<ResourceLocation> missions = MercenaryPlayerData.getMercenaryMissionsAvailable(playerData, mercenaryName);
        int indexMission = 0;
        for (Object mission : missions) {
            if (mission.toString().equals(missionId.toString())) break;
            ++indexMission;
        }
        ResourceLocation newMissionId = missionId;
        if (indexMission < missions.size()) {
            Object mission;
            mission = Mission.getMissionFromId(missionId);
            assert (mission != null);
            while (missionId.toString().equals(newMissionId.toString())) {
                newMissionId = MercenaryPlayerData.generateSingleMissionRarityForMercenary(mercenaryName, mission.rarity);
                if (newMissionId.toString().equals(missionId.toString()) || MercenaryPlayerData.isMercenaryMissionAvailable(playerData, mercenaryName, newMissionId)) continue;
                missions.set(indexMission, newMissionId);
            }
        } else {
            return;
        }
        int rerollsLeft = MercenaryPlayerData.getMercenaryMissionRerollLeft(playerData, mercenaryName);
        mercenaryData.m_128405_("Reroll", rerollsLeft - 1);
        MercenaryPlayerData.setMercenaryMissionsAvailable(playerData, mercenaryName, missions);
        MercenaryPlayerData.generateMercenaryNewMissionSeed(playerData, mercenaryName, newMissionId);
    }

    public static int getMercenaryLevelsLeftToSpend(PlayerData playerData, String mercenaryName) {
        int mercenaryLevel = MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName);
        int levelsSpent = MercenaryPlayerData.getMercenaryLevelsSpent(playerData, mercenaryName);
        return mercenaryLevel - (levelsSpent + 1);
    }

    public static boolean canMercenaryTraitLevelUp(PlayerData playerData, String mercenaryName, String traitName) {
        if (MercenaryPlayerData.getMercenaryLevelsLeftToSpend(playerData, mercenaryName) <= 0) {
            return false;
        }
        Trait trait = Trait.getTrait(traitName);
        int maxLevel = trait.maxLevel;
        return maxLevel == -1 || MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenaryName, traitName) < maxLevel;
    }

    public static void clearMercenaryMissionsAvailable(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        CompoundTag missionsAvailableTag = mercenaryTag.m_128469_("MissionsAvailable");
        HashSet keysCopy = new HashSet(missionsAvailableTag.m_128431_());
        for (String mission : keysCopy) {
            missionsAvailableTag.m_128473_(mission);
            missionsAvailableTag.m_128365_(mission, (Tag)MercenaryPlayerData.getEmptyMercenaryMissionTag());
        }
    }

    public static void setMercenaryMissionTimerFinish(PlayerData playerData, String mercenaryName) {
        MercenaryPlayerData.setMercenaryMissionTimeLeft(playerData, mercenaryName, 0);
        MercenaryPlayerData.setMercenaryMissionStatus(playerData, mercenaryName, "EndMission");
    }

    public static int getMercenaryCurrentHealth(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128451_("CurrentHealth");
    }

    public static int getMercenaryMaxHealth(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128451_("MaxHealth");
    }

    public static void damageMercenary(PlayerData playerData, String mercenaryName, int damage) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("CurrentHealth", Math.max(mercenaryTag.m_128451_("CurrentHealth") - damage, 0));
        MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "DamageTaken", damage);
    }

    public static boolean isMercenaryDead(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128451_("CurrentHealth") <= 0;
    }

    public static boolean isMercenaryIdle(PlayerData playerData, String mercenaryName) {
        return MercenaryPlayerData.getMercenaryMissionStatus(playerData, mercenaryName).equals("None");
    }

    public static boolean isMercenaryOnMission(PlayerData playerData, String mercenaryName) {
        return MercenaryPlayerData.getMercenaryMissionStatus(playerData, mercenaryName).equals("Ongoing");
    }

    public static boolean isMercenaryWaitingMissionResult(PlayerData playerData, String mercenaryName) {
        return MercenaryPlayerData.getMercenaryMissionStatus(playerData, mercenaryName).equals("EndMission");
    }

    public static int getMercenaryMissionSeed(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        CompoundTag missionTag = MercenaryPlayerData.getMercenaryMissionTag(playerData, mercenaryName, missionId);
        assert (missionTag != null);
        return missionTag.m_128451_("Seed");
    }

    public static CompoundTag getMercenaryMissionsAvailableTag(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128469_("MissionsAvailable");
    }

    public static void generateMercenaryNewMissionsSeed(PlayerData playerData, String mercenaryName) {
        CompoundTag missionsTag = MercenaryPlayerData.getMercenaryMissionsAvailableTag(playerData, mercenaryName);
        for (String mission : missionsTag.m_128431_()) {
            CompoundTag missionTag = missionsTag.m_128469_(mission);
            int newSeed = Utils.generateSeed();
            missionTag.m_128405_("Seed", newSeed);
        }
    }

    public static void generateMercenaryNewMissionSeed(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        CompoundTag missionTag = MercenaryPlayerData.getMercenaryMissionTag(playerData, mercenaryName, missionId);
        int newSeed = Utils.generateSeed();
        assert (missionTag != null);
        missionTag.m_128405_("Seed", newSeed);
    }

    public static void generateMercenaryNewSeed(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("Seed", Utils.generateSeed());
        if (mercenaryTag.m_128441_("ShopStatus")) {
            MercenaryPlayerData.resetShopkeeperItemsStatus(playerData, mercenaryName);
        }
    }

    public static void applyRegenTraitToMercenary(PlayerData playerData, String mercenaryName) {
        int regenTraitLevel = MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenaryName, "Regeneration");
        MercenaryPlayerData.healMercenary(playerData, mercenaryName, regenTraitLevel / 2);
    }

    public static void finishMercenaryMission(PlayerData playerData, String mercenaryName, String status) {
        MercenaryPlayerData.setMercenaryChosenMission(playerData, mercenaryName, NBTKeys.MISSION_EMPTY_ID.toString());
        MercenaryPlayerData.setMercenaryMissionTimes(playerData, mercenaryName, 0);
        MercenaryPlayerData.setMercenaryMissionStatus(playerData, mercenaryName, "None");
        MercenaryPlayerData.clearMercenaryMissionsAvailable(playerData, mercenaryName);
        if (status.equals("Success")) {
            MercenaryPlayerData.applyRegenTraitToMercenary(playerData, mercenaryName);
        }
        if (!Module.isModuleActive(playerData, "Skipping Module")) {
            MercenaryPlayerData.generateRecruitsForPlayer(playerData);
        } else {
            MercenaryPlayerData.removeAvailableRecruit(playerData, mercenaryName);
        }
    }

    public static int howManyMercenariesOnMission(PlayerData playerData) {
        int count = 0;
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenariesTag(playerData);
        for (String mercenaryName : mercenaryTag.m_128431_()) {
            if (!MercenaryPlayerData.isMercenaryOnMission(playerData, mercenaryName)) continue;
            ++count;
        }
        return count;
    }

    public static int howManyMercenariesCanBeSentOnMission(PlayerData playerData) {
        if (Module.isModuleActive(playerData, "Dual Boot Module")) {
            return 2;
        }
        return 1;
    }

    public static boolean canPlayerRecruitMercenaries(PlayerData playerData) {
        return MercenaryPlayerData.howManyMercenariesOnMission(playerData) < MercenaryPlayerData.howManyMercenariesCanBeSentOnMission(playerData);
    }

    public static void applyMercenaryDeathPenalty(PlayerData playerData, String mercenaryName) {
        if (MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName) > 1 && MercenaryPlayerData.getMercenaryLevelsLeftToSpend(playerData, mercenaryName) < 1) {
            MercenaryPlayerData.removeMercenaryRandomTraitLevel(playerData, mercenaryName);
            int levelsSpent = MercenaryPlayerData.getMercenaryLevelsSpent(playerData, mercenaryName);
            if (levelsSpent > 0) {
                MercenaryPlayerData.setMercenaryLevelsSpent(playerData, mercenaryName, levelsSpent - 1);
            }
        }
        MercenaryPlayerData.downLevelMercenary(playerData, mercenaryName);
        MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "Deaths");
    }

    public static void removeMercenaryRandomTraitLevel(PlayerData playerData, String mercenaryName) {
        String traitToDelevel = MercenaryPlayerData.getMercenaryRandomTraitDeathTarget(playerData, mercenaryName);
        if (traitToDelevel == null) {
            return;
        }
        CompoundTag traitsTag = MercenaryPlayerData.getMercenaryTraitsTag(playerData, mercenaryName);
        int currentLevel = traitsTag.m_128451_(traitToDelevel);
        traitsTag.m_128405_(traitToDelevel, currentLevel - 1);
        if (traitToDelevel.equals("Sturdiness")) {
            MercenaryPlayerData.recalculateMercenaryMaxHealth(playerData, mercenaryName);
        }
    }

    public static String getMercenaryRandomTraitDeathTarget(PlayerData playerData, String mercenaryName) {
        CompoundTag traitsTag = MercenaryPlayerData.getMercenaryTraitsTag(playerData, mercenaryName);
        ArrayList<String> eligibleTraits = new ArrayList<String>();
        for (String traitName : traitsTag.m_128431_()) {
            if (traitsTag.m_128451_(traitName) <= 0) continue;
            eligibleTraits.add(traitName);
        }
        if (eligibleTraits.isEmpty()) {
            return null;
        }
        int traitIndex = (MercenaryPlayerData.getMercenarySeed(playerData, mercenaryName) + 564) % eligibleTraits.size();
        return (String)eligibleTraits.get(traitIndex);
    }

    public static void downLevelMercenary(PlayerData playerData, String mercenaryName) {
        int currentLevel = MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName);
        if (currentLevel > 1) {
            int expNeeded = Mercenary.getRequiredExpLevel(currentLevel - 1);
            MercenaryPlayerData.setMercenaryExp(playerData, mercenaryName, expNeeded);
        } else {
            MercenaryPlayerData.setMercenaryExp(playerData, mercenaryName, 0);
        }
    }

    public static void setRecruitMercenary(PlayerData playerData, String mercenaryName, int index) {
        CompoundTag recruitsAvailable = MercenaryPlayerData.getRecruitsAvailableTag(playerData);
        recruitsAvailable.m_128359_("Recruit" + (index + 1), mercenaryName);
    }

    public static int getRequiredPlayerLevelToResurrectMercenary(PlayerData playerData, String mercenaryName) {
        int mercenaryLevel = MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName);
        return mercenaryLevel + 10;
    }

    public static void resurrectMercenary(PlayerData playerData, String mercenaryName) {
        MercenaryPlayerData.healMercenaryPercent(playerData, mercenaryName, 25);
    }

    public static int getMercenaryMissionRerollLeft(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128451_("Reroll");
    }

    public static void resetMercenaryMissionReroll(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        if (Module.isModuleActive(playerData, "Dice Module")) {
            if (Module.isModuleActive(playerData, "Multi-Dice Module")) {
                if (Module.isModuleActive(playerData, "D100 Module")) {
                    int level = MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName);
                    mercenaryTag.m_128405_("Reroll", 3 + level / 5);
                } else {
                    mercenaryTag.m_128405_("Reroll", 2);
                }
            } else {
                mercenaryTag.m_128405_("Reroll", 1);
            }
        } else {
            mercenaryTag.m_128405_("Reroll", 0);
        }
    }

    public static void resetMercenaryTraits(PlayerData playerData, String mercenaryName) {
        for (Map.Entry<String, Trait> entry : Trait.getTraitsMap()) {
            MercenaryPlayerData.setMercenaryTraitLevel(playerData, mercenaryName, entry.getKey(), 0);
        }
        MercenaryPlayerData.recalculateMercenaryMaxHealth(playerData, mercenaryName);
        MercenaryPlayerData.setMercenaryLevelsSpent(playerData, mercenaryName, 0);
    }

    public static void resetAllMercenaryCurrentMission(PlayerData playerData) {
        for (String mercenaryName : Mercenary.getMercenariesName()) {
            MercenaryPlayerData.setMercenaryChosenMission(playerData, mercenaryName, NBTKeys.MISSION_EMPTY_ID.toString());
            MercenaryPlayerData.setMercenaryMissionTimes(playerData, mercenaryName, 0);
            MercenaryPlayerData.setMercenaryMissionStatus(playerData, mercenaryName, "None");
            MercenaryPlayerData.clearMercenaryMissionsAvailable(playerData, mercenaryName);
        }
    }

    public static int getMercenaryMissionArrayIndex(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        List<ResourceLocation> missions = MercenaryPlayerData.getMercenaryMissionsAvailable(playerData, mercenaryName);
        int index = 0;
        for (ResourceLocation missionIndex : missions) {
            if (missionIndex.toString().equals(missionId.toString())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static String getMercenaryMissionDifficulty(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        int arrayIndex = MercenaryPlayerData.getMercenaryMissionArrayIndex(playerData, mercenaryName, missionId);
        if (arrayIndex != -1) {
            return Mission.mapIndexDifficulty.get(MercenaryPlayerData.getMercenaryMissionsDifficulty(playerData, mercenaryName).get(arrayIndex));
        }
        return "Normal";
    }

    public static int getMercenaryMissionDifficultyIndex(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        int arrayIndex = MercenaryPlayerData.getMercenaryMissionArrayIndex(playerData, mercenaryName, missionId);
        if (arrayIndex != -1) {
            return MercenaryPlayerData.getMercenaryMissionsDifficulty(playerData, mercenaryName).get(arrayIndex);
        }
        return 0;
    }

    public static CompoundTag getMercenaryMissionTag(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        CompoundTag missionsTag = mercenaryTag.m_128469_("MissionsAvailable");
        for (int index = 1; index <= playerData.getNumberOfMissions(); ++index) {
            CompoundTag missionTag = missionsTag.m_128469_("Mission" + index);
            if (!missionId.toString().equals(missionTag.m_128461_("Id"))) continue;
            return missionTag;
        }
        return null;
    }

    public static void changeMercenaryMissionDifficulty(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        CompoundTag missionTag = MercenaryPlayerData.getMercenaryMissionTag(playerData, mercenaryName, missionId);
        if (missionTag != null) {
            int currentDifficulty = missionTag.m_128451_("Difficulty");
            int maxDifficulty = 1;
            if (Module.isModuleActive(playerData, "Mythic Difficulty Module")) {
                maxDifficulty = 3;
            } else if (Module.isModuleActive(playerData, "Heroic Difficulty Module")) {
                maxDifficulty = 2;
            }
            currentDifficulty = (currentDifficulty + 1) % maxDifficulty;
            missionTag.m_128405_("Difficulty", currentDifficulty);
        }
    }

    public static int getMercenaryBaseMissionCoins(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        int seed = MercenaryPlayerData.getMercenaryMissionSeed(playerData, mercenaryName, missionId);
        Mission mission = Mission.getMissionFromId(missionId);
        assert (mission != null);
        int maxCoins = Mission.getMissionMaxCoins(mission.rarity);
        return (seed + 50637) % maxCoins + 1;
    }

    public static int getMercenaryMissionCoins(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        return MercenaryPlayerData.getMercenaryBaseMissionCoins(playerData, mercenaryName, missionId) * MercenaryPlayerData.getMercenaryMissionDifficultyMultiplier(playerData, mercenaryName, missionId);
    }

    public static int getMercenaryMissionTotalCoins(PlayerData playerData, String mercenaryName, ResourceLocation missionId) {
        int multiplier = MercenaryPlayerData.getMercenaryMissionTotalMultiplier(playerData, mercenaryName, missionId);
        int initialCoins = MercenaryPlayerData.getMercenaryBaseMissionCoins(playerData, mercenaryName, missionId);
        return initialCoins * multiplier;
    }

    public static boolean isMercenaryNotAvailable(PlayerData playerData, String mercenaryName) {
        CompoundTag recruitsAvailableTag = MercenaryPlayerData.getRecruitsAvailableTag(playerData);
        for (String key : recruitsAvailableTag.m_128431_()) {
            if (!recruitsAvailableTag.m_128461_(key).equals(mercenaryName)) continue;
            return false;
        }
        return true;
    }

    public static boolean isShopkeeperItemAvailable(PlayerData playerData, String shopkeeperName, int index) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, shopkeeperName);
        if (mercenaryTag.m_128441_("ShopStatus") && index < Shopkeeper.maxItems) {
            return mercenaryTag.m_128463_("ShopStatus")[index] == 0;
        }
        return false;
    }

    public static void setShopkeeperItemBought(PlayerData playerData, String shopkeeperName, int index) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, shopkeeperName);
        byte[] shopStatusArray = mercenaryTag.m_128463_("ShopStatus");
        shopStatusArray[index] = 1;
        mercenaryTag.m_128382_("ShopStatus", shopStatusArray);
    }

    public static void resetShopkeeperItemsStatus(PlayerData playerData, String shopkeeperName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, shopkeeperName);
        byte[] shopStatusArray = new byte[Shopkeeper.maxItems];
        mercenaryTag.m_128382_("ShopStatus", shopStatusArray);
    }

    public static byte[] getShopkeeperShopStatus(PlayerData playerData, String shopkeeperName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, shopkeeperName);
        return mercenaryTag.m_128463_("ShopStatus");
    }

    public static CompoundTag getMercenaryTag(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenariesTag(playerData);
        return mercenaryTag.m_128469_(mercenaryName);
    }

    public static void saveMercenaryMissionTimersToNBT(Map<String, Integer> missionTimeLeft, CompoundTag mainTag) {
        if (!missionTimeLeft.isEmpty()) {
            CompoundTag timersTag = new CompoundTag();
            missionTimeLeft.forEach((arg_0, arg_1) -> ((CompoundTag)timersTag).m_128405_(arg_0, arg_1));
            mainTag.m_128365_("MissionTimers", (Tag)timersTag);
        }
    }

    public static void loadMercenaryMissionTimersFromNBT(Map<String, Integer> missionTimeLeft, CompoundTag mainTag) {
        missionTimeLeft.clear();
        if (mainTag.m_128425_("MissionTimers", 10)) {
            CompoundTag timersTag = mainTag.m_128469_("MissionTimers");
            for (String key : timersTag.m_128431_()) {
                missionTimeLeft.put(key, timersTag.m_128451_(key));
            }
        }
    }

    public static CompoundTag getEmptyMercenaryMissionTag() {
        CompoundTag missionTag = new CompoundTag();
        missionTag.m_128359_("Id", NBTKeys.MISSION_EMPTY_ID.toString());
        missionTag.m_128405_("Difficulty", 0);
        missionTag.m_128405_("Seed", 0);
        return missionTag;
    }

    public static CompoundTag getEmptyMercenaryQuestTag() {
        CompoundTag questTag = new CompoundTag();
        questTag.m_128359_("RequirementId", "None");
        questTag.m_128359_("RewardId", "None");
        questTag.m_128405_("Seed", Utils.generateSeed());
        return questTag;
    }

    public static CompoundTag generateMercenaryQuest() {
        String trait;
        String mercenary;
        String rarity;
        CompoundTag questTag = new CompoundTag();
        String requirementId = Quest.generateRandomQuestObjective(Utils.generateSeed());
        String rewardId = Quest.generateRandomQuestReward(Utils.generateSeed());
        questTag.m_128359_("RequirementId", requirementId);
        questTag.m_128359_("RewardId", rewardId);
        int questSeed = Utils.generateSeed();
        questTag.m_128405_("RequirementProgress", 0);
        if (requirementId.contains("Rarity")) {
            rarity = Quest.generateRandomQuestRarity(questSeed, true);
            questTag.m_128359_("RequirementTargetRarity", rarity);
        }
        if (rewardId.contains("Rarity")) {
            rarity = Quest.generateRandomQuestRarity(questSeed, false);
            questTag.m_128359_("RewardTargetRarity", rarity);
        }
        if (requirementId.contains("Mercenary")) {
            mercenary = Quest.generateRandomQuestMercenary(questSeed, true);
            questTag.m_128359_("RequirementTargetMercenary", mercenary);
        }
        if (rewardId.contains("Mercenary")) {
            mercenary = Quest.generateRandomQuestMercenary(questSeed, false);
            questTag.m_128359_("RewardTargetMercenary", mercenary);
        }
        if (requirementId.contains("Trait")) {
            trait = Quest.generateRandomQuestTrait(questSeed, true);
            questTag.m_128359_("RequirementTargetTrait", trait);
        }
        if (rewardId.contains("Trait")) {
            trait = Quest.generateRandomQuestTrait(questSeed, false);
            questTag.m_128359_("RewardTargetTrait", trait);
        }
        if (requirementId.contains("Number")) {
            int number = Quest.getQuestRandomNumber(questSeed, requirementId);
            questTag.m_128405_("RequirementNumber", number);
        }
        if (rewardId.contains("Number")) {
            int number = Quest.getQuestRandomNumber(questSeed, rewardId);
            questTag.m_128405_("RewardNumber", number);
        }
        questTag.m_128405_("Seed", questSeed);
        return questTag;
    }

    public static void generateAllMercenaryQuests(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        CompoundTag questsTag = MercenaryPlayerData.getMercenaryQuestsTag(playerData, mercenaryName);
        for (int i = 1; i <= playerData.getNumberOfQuests(); ++i) {
            questsTag.m_128365_("Quest" + i, (Tag)MercenaryPlayerData.generateMercenaryQuest());
        }
        mercenaryTag.m_128405_("ChosenQuest", 0);
        mercenaryTag.m_128359_("QuestStatus", "None");
    }

    public static void generateAllMercenaryQuestsIfNecessary(PlayerData playerData, String mercenaryName) {
        CompoundTag questsTag = MercenaryPlayerData.getMercenaryQuestsTag(playerData, mercenaryName);
        if (questsTag.m_128469_("Quest1").m_128461_("RequirementId").equals("None")) {
            MercenaryPlayerData.generateAllMercenaryQuests(playerData, mercenaryName);
        }
    }

    public static boolean hasPlayerAcceptedAMercenaryQuest(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128451_("ChosenQuest") != 0;
    }

    public static boolean isPlayerChosenMercenaryQuestCompleted(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128461_("QuestStatus").equals("Success");
    }

    public static boolean isMercenaryTraitMaximumLevel(PlayerData playerData, String mercenaryName, String traitName) {
        int level = MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenaryName, traitName);
        int maxLevel = Trait.getTrait((String)traitName).maxLevel;
        if (maxLevel == -1) {
            return false;
        }
        return level >= maxLevel;
    }

    public static CompoundTag getEmptyStatisticsTag(boolean isShopkeeper) {
        CompoundTag statistics = new CompoundTag();
        if (isShopkeeper) {
            statistics.m_128405_("TotalCoins", 0);
            statistics.m_128405_("CommonItems", 0);
            statistics.m_128405_("UncommonItems", 0);
            statistics.m_128405_("RareItems", 0);
            statistics.m_128405_("EpicItems", 0);
            statistics.m_128405_("LegendaryItems", 0);
            statistics.m_128405_("TotalQuests", 0);
            statistics.m_128405_("QuestsSuccess", 0);
        } else {
            statistics.m_128405_("CommonStarted", 0);
            statistics.m_128405_("CommonSuccess", 0);
            statistics.m_128405_("UncommonStarted", 0);
            statistics.m_128405_("UncommonSuccess", 0);
            statistics.m_128405_("RareStarted", 0);
            statistics.m_128405_("RareSuccess", 0);
            statistics.m_128405_("EpicStarted", 0);
            statistics.m_128405_("EpicSuccess", 0);
            statistics.m_128405_("LegendaryStarted", 0);
            statistics.m_128405_("LegendarySuccess", 0);
            statistics.m_128405_("Fails", 0);
            statistics.m_128405_("Deaths", 0);
            statistics.m_128405_("DamageTaken", 0);
            statistics.m_128405_("Bribe", 0);
            statistics.m_128405_("Totem", 0);
        }
        return statistics;
    }

    public static CompoundTag getMercenaryStatisticsTag(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128469_("Statistics");
    }

    public static void incrementMercenaryStat(PlayerData playerData, String mercenaryName, String statKey, int amount) {
        CompoundTag statsTag = MercenaryPlayerData.getMercenaryStatisticsTag(playerData, mercenaryName);
        statsTag.m_128405_(statKey, statsTag.m_128451_(statKey) + amount);
    }

    public static void incrementMercenaryStat(PlayerData playerData, String mercenaryName, String statKey) {
        MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, statKey, 1);
    }

    public static void incrementMercenarySentMissionStat(PlayerData playerData, String mercenaryName, String rarity) {
        switch (rarity) {
            case "Common": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "CommonStarted");
                break;
            }
            case "Uncommon": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "UncommonStarted");
                break;
            }
            case "Rare": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "RareStarted");
                break;
            }
            case "Epic": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "EpicStarted");
                break;
            }
            case "Legendary": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "LegendaryStarted");
            }
        }
    }

    public static void incrementMercenarySuccessMissionStat(PlayerData playerData, String mercenaryName, String rarity) {
        switch (rarity) {
            case "Common": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "CommonSuccess");
                break;
            }
            case "Uncommon": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "UncommonSuccess");
                break;
            }
            case "Rare": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "RareSuccess");
                break;
            }
            case "Epic": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "EpicSuccess");
                break;
            }
            case "Legendary": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "LegendarySuccess");
            }
        }
    }

    public static int getCurrentMercenaryCoins(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128451_("Coins");
    }

    public static void addMercenaryCoins(PlayerData playerData, String mercenaryName, int coins) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("Coins", MercenaryPlayerData.getCurrentMercenaryCoins(playerData, mercenaryName) + coins);
        MercenaryPlayerData.incrementMercenaryStat(playerData, "Vael", "TotalCoins", coins);
    }

    public static void setMercenaryCoins(PlayerData playerData, String mercenaryName, int coins) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("Coins", coins);
    }

    public static void incrementShopkeeperItemRarityStat(PlayerData playerData, String mercenaryName, String rarity) {
        switch (rarity) {
            case "Common": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "CommonItems");
                break;
            }
            case "Uncommon": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "UncommonItems");
                break;
            }
            case "Rare": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "RareItems");
                break;
            }
            case "Epic": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "EpicItems");
                break;
            }
            case "Legendary": {
                MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "LegendaryItems");
            }
        }
    }

    public static int getMercenaryCurrentHunger(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128451_("Hunger");
    }

    public static int getMercenaryMaximumHunger(PlayerData playerData, String mercenaryName) {
        int level = MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName);
        int traitBonus = MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenaryName, "Voracious");
        return 9 + level + traitBonus;
    }

    public static void setMercenaryHunger(PlayerData playerData, String mercenaryName, int hunger) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128405_("Hunger", hunger);
    }

    public static boolean isMercenaryFed(PlayerData playerData, String mercenaryName) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        return mercenaryTag.m_128471_("Fed");
    }

    public static void setMercenaryFed(PlayerData playerData, String mercenaryName, boolean fed) {
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        mercenaryTag.m_128379_("Fed", fed);
    }
}

