/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.mercenary;

import io.github.sluggly.timemercenaries.TimeMercenaryAdvancements;
import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class Trait {
    public final String name;
    public final int maxLevel;
    public final Item itemTexture;
    private final String description;
    private final Function<Integer, Integer> descriptionValueCalculator;
    private static final ArrayList<Trait> traitArray = new ArrayList();
    private static final Map<String, Trait> traitMap = new HashMap<String, Trait>();

    public Trait(String name, int maxLevel, Item itemTexture, String description, Function<Integer, Integer> descriptionValueCalculator) {
        this.name = name;
        this.maxLevel = maxLevel;
        this.itemTexture = itemTexture;
        this.description = description;
        this.descriptionValueCalculator = descriptionValueCalculator;
    }

    public static void levelUpTrait(ServerPlayer player, String mercenaryName, String traitName) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (MercenaryPlayerData.canMercenaryTraitLevelUp(playerData, mercenaryName, traitName)) {
            MercenaryPlayerData.manualMercenaryTraitLevelUp(playerData, mercenaryName, traitName);
            PacketHandler.sendToPlayer("TraitLeveled", playerData, player);
            TimeMercenaryAdvancements.checkAndTestGrantAdvancement(player, "Traits");
        }
    }

    public static void playerMercenaryResetTraits(ServerPlayer player, String mercenaryName) {
        boolean canReset;
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (playerData == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        MissionItem resetTraitsItem = Mercenary.resetTraitsItem;
        if (!Utils.hasEnoughItems(resetTraitsItem.itemStack.m_41720_(), (Player)player, resetTraitsItem.number)) {
            Admin.playerRequestError((Player)player, "Player has not enough item to reset Traits.");
            return;
        }
        boolean bl = canReset = MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName) > 0;
        if (!canReset) {
            for (Map.Entry<String, Trait> entry : Trait.getTraitsMap()) {
                if (MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenaryName, entry.getKey()) <= 0) continue;
                canReset = true;
                break;
            }
        }
        if (!canReset) {
            return;
        }
        Utils.removeItemInInventory(resetTraitsItem.itemStack.m_41720_(), resetTraitsItem.number, (Player)player);
        MercenaryPlayerData.resetMercenaryTraits(playerData, mercenaryName);
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
    }

    public String getDescription(int level) {
        return this.description.formatted(level, this.descriptionValueCalculator.apply(level));
    }

    private static void createTrait(String name, int maxLevel, Item itemTexture, String description, Function<Integer, Integer> descriptionValueCalculator) {
        Trait trait = new Trait(name, maxLevel, itemTexture, description, descriptionValueCalculator);
        traitArray.add(trait);
        traitMap.put(name, trait);
    }

    public static void populateTraits() {
        Trait.createTrait("Speed", -1, Items.f_42467_, "Speed Trait Level %d\nCurrent Mission Speed: %d%%\n+10%% per Level, no Maximum Level.", level -> 100 + 10 * level);
        Trait.createTrait("Reliable", -1, Items.f_42430_, "Reliable Trait Level %d\nReduce the chances to fail a mission: -%d%%\n-1%% per Level, No Maximum Level.", level -> level);
        Trait.createTrait("Sturdiness", -1, Items.f_42619_, "Sturdiness Trait Level %d\nAdds %d bonus maximum health points.\n1 per 2 Levels, No Maximum Level.", level -> level / 2);
        Trait.createTrait("Greedy", 20, Items.f_42415_, "Greedy Trait Level %d\nIncrease the chance to doubles the rewards: %d%%\n+5%% per Level, Level 20 Maximum.", level -> 5 * level);
        Trait.createTrait("Knowledgeable", -1, Items.f_42612_, "Knowledgeable Trait Level %d\nIncrease the experience gained after each mission: %d%%\n+25%% per Level, no Maximum Level.", level -> 25 * level);
        Trait.createTrait("Scavenger", 100, Items.f_42584_, "Scavenger Trait Level %d\nIncrease the chance to permanently upgrade a random trait after a mission success: %d%%\n+1%% per Level, Level 100 Maximum.", level -> level);
        Trait.createTrait("Regeneration", -1, Items.f_42436_, "Regeneration Trait Level %d\nRegenerate %d health after a mission success.\n+1 per 2 Levels, No Maximum Level.", level -> level / 2);
        Trait.createTrait("Procurer", 200, Items.f_151058_, "Procurer Trait Level %d\nGrants %d%% chance to make a mission's item cost free.\n+1%% per 2 Level, 200 Maximum Level.", level -> level / 2);
        Trait.createTrait("Voracious", -1, Items.f_42486_, "Voracious Trait Level %d\nIncreases maximum hunger by %d.\n+1 Max Hunger per level, No Maximum Level.", level -> level);
    }

    public static Trait getTrait(String name) {
        return traitMap.get(name);
    }

    public static Trait getTrait(int index) {
        return traitArray.get(index);
    }

    public static ArrayList<Trait> getTraits() {
        return traitArray;
    }

    public static Set<Map.Entry<String, Trait>> getTraitsMap() {
        return traitMap.entrySet();
    }
}

