/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.missions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryManager;
import io.github.sluggly.timemercenaries.mercenary.Shopkeeper;
import io.github.sluggly.timemercenaries.missions.Mission;
import io.github.sluggly.timemercenaries.missions.MissionDefinition;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class MissionManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String DIRECTORY = "missions";
    private static final MissionManager INSTANCE = new MissionManager();
    private Map<ResourceLocation, MissionDefinition> loadedDefinitions = new HashMap<ResourceLocation, MissionDefinition>();
    private boolean jsonLoaded = false;
    private boolean processed = false;

    private MissionManager() {
        super(GSON, DIRECTORY);
    }

    public static MissionManager getMissionManager() {
        return INSTANCE;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonObjects, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        HashMap<ResourceLocation, MissionDefinition> loadedMissions = new HashMap<ResourceLocation, MissionDefinition>();
        jsonObjects.forEach((location, jsonElement) -> {
            try {
                MissionDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).resultOrPartial(error -> System.err.println("Failed to parse mission " + String.valueOf(location) + ": " + error)).ifPresent(mission -> loadedMissions.put((ResourceLocation)location, (MissionDefinition)mission));
            }
            catch (Exception e) {
                System.err.println("Exception while parsing mission " + String.valueOf(location) + e.getMessage());
            }
        });
        this.loadedDefinitions = loadedMissions;
        this.jsonLoaded = true;
        this.processed = false;
        System.out.println("Loaded " + this.loadedDefinitions.size() + " mission definitions.");
        this.tryProcess();
    }

    public void resetProcessedFlag() {
        this.processed = false;
    }

    public void tryProcess() {
        if (this.processed) {
            return;
        }
        if (!this.jsonLoaded) {
            return;
        }
        if (!MercenaryManager.getMercenaryManager().isProcessed()) {
            return;
        }
        System.out.println("[MissionManager] Processing missions...");
        this.processAndRegisterMissions();
        this.processed = true;
    }

    private void processAndRegisterMissions() {
        this.distributeMissionsToMercenaries();
        this.postProcessSpecialMercenaries();
        System.out.println("Registered missions for enabled mercenaries.");
    }

    private void distributeMissionsToMercenaries() {
        for (Map.Entry<String, Mercenary> entry : Mercenary.getMercenariesEntrySet()) {
            Mercenary mercenary = Mercenary.getMercenary(entry.getKey());
            mercenary.missionRarityList.forEach((Consumer<ArrayList<ResourceLocation>>)((Consumer<ArrayList>)ArrayList::clear));
        }
        this.loadedDefinitions.forEach((id, definition) -> {
            Mercenary mercenary = Mercenary.getMercenary(definition.mercenary());
            if (mercenary != null) {
                mercenary.addMission((ResourceLocation)id, definition.rarity());
            }
        });
    }

    private void postProcessSpecialMercenaries() {
        Shopkeeper shopkeeper;
        Mercenary chaos = Mercenary.getMercenary("Chaos");
        if (chaos != null) {
            for (Map.Entry<String, Mercenary> entry : Mercenary.getMercenariesEntrySet()) {
                Mercenary mercenary = Mercenary.getMercenary(entry.getKey());
                if (mercenary.name.equals("Chaos") || mercenary instanceof Shopkeeper) continue;
                for (int i = 0; i < mercenary.missionRarityList.size(); ++i) {
                    chaos.missionRarityList.get(i).addAll((Collection<ResourceLocation>)mercenary.missionRarityList.get(i));
                }
            }
        }
        if ((shopkeeper = (Shopkeeper)Mercenary.getMercenary("Vael")) != null) {
            for (Map.Entry<ResourceLocation, MissionDefinition> entry : this.loadedDefinitions.entrySet()) {
                Mission mission = new Mission(entry.getKey(), entry.getValue());
                if (mission.isRandomMission) continue;
                for (MissionItem item : mission.getSuccessItems(-1)) {
                    if (item.entity != null || item.itemStack == null) continue;
                    shopkeeper.addItemToList(mission.rarity, item.itemStack);
                }
            }
        }
    }

    public void setMissions(Map<ResourceLocation, MissionDefinition> missions) {
        this.loadedDefinitions = missions;
        this.processAndRegisterMissions();
        System.out.println("Client received and loaded " + this.loadedDefinitions.size() + " missions.");
    }

    public MissionDefinition getMission(ResourceLocation id) {
        this.tryProcess();
        return this.loadedDefinitions.get(id);
    }

    public Map<ResourceLocation, MissionDefinition> getAllMissions() {
        this.tryProcess();
        return this.loadedDefinitions;
    }

    public Map<ResourceLocation, MissionDefinition> getEnabledMissions() {
        this.tryProcess();
        return this.loadedDefinitions.entrySet().stream().filter(entry -> Mercenary.getMercenary(((MissionDefinition)entry.getValue()).mercenary()) != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

