/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.module;

import io.github.sluggly.timemercenaries.TimeMercenaryAdvancements;
import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.capability.PlayerCapability;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import io.github.sluggly.timemercenaries.module.ModuleDefinition;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import org.jetbrains.annotations.Nullable;

public class Module {
    public final String name;
    public final int index = moduleArray.size();
    public final int row;
    public final int column;
    public final int color;
    public final String[] requirements;
    public final MissionItem[] unlockItems;
    public final Item itemTexture;
    public final String description;
    private static final ArrayList<Module> moduleArray = new ArrayList();
    private static final Map<String, Module> moduleMap = new HashMap<String, Module>();
    public static final int SLEEPING_MODULE_REDUCTION = 120;

    public Module(ModuleDefinition definition) {
        this.name = definition.name();
        this.row = definition.row();
        this.column = definition.column();
        this.color = this.getModuleColor(this.row);
        this.requirements = definition.requirements().toArray(new String[0]);
        this.itemTexture = definition.icon();
        this.unlockItems = definition.cost().toArray(new MissionItem[0]);
        this.description = definition.description();
        moduleArray.add(this);
        moduleMap.put(this.name, this);
    }

    public Module(String name, int row, int column, String[] requirements, Item itemTexture, MissionItem[] unlockItems, String description) {
        this.name = name;
        this.row = row;
        this.column = column;
        this.color = this.getModuleColor(row);
        this.requirements = requirements;
        this.itemTexture = itemTexture;
        this.unlockItems = unlockItems;
        this.description = description;
        moduleArray.add(this);
        moduleMap.put(name, this);
    }

    public static void unlockModule(ServerPlayer player, int moduleIndex) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (!Module.checkIfPlayerCanUnlockModule(moduleIndex, (Player)player, true)) {
            return;
        }
        Module module = Module.getModule(moduleIndex);
        for (MissionItem missionItem : module.unlockItems) {
            Utils.removeItemInInventory(missionItem.itemStack.m_41720_(), missionItem.number, (Player)player);
        }
        Module.setModule(playerData, module.name, true);
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
        TimeMercenaryAdvancements.checkAndTestGrantAdvancement(player, "Modules");
    }

    public static void generateAndAttachBaseModuleCompoundTag(CompoundTag playerData) {
        if (playerData.m_128441_("Modules")) {
            playerData.m_128473_("Modules");
        }
        CompoundTag modules = new CompoundTag();
        for (Map.Entry<String, Module> entry : Module.getModules()) {
            modules.m_128379_(entry.getKey(), false);
        }
        playerData.m_128365_("Modules", (Tag)modules);
    }

    public static CompoundTag getModulesTag(PlayerData playerData) {
        return playerData.playerDataTag.m_128469_("Modules");
    }

    public static boolean isModuleActive(PlayerData playerData, String moduleName) {
        CompoundTag modulesTag = Module.getModulesTag(playerData);
        return modulesTag.m_128471_(moduleName);
    }

    public static boolean doesDimensionalGlitchModuleProc(PlayerData playerData, String mercenaryName) {
        if (!Module.isModuleActive(playerData, "Dimensional Glitch Module")) {
            return false;
        }
        return (MercenaryPlayerData.getMercenarySeed(playerData, mercenaryName) + 85857) % 100 < 25;
    }

    public static void setModule(PlayerData playerData, String module, boolean bool) {
        CompoundTag moduleTag = Module.getModulesTag(playerData);
        moduleTag.m_128379_(module, bool);
        if (module.equals("Dice Module") || module.equals("Multi-Dice Module") || module.equals("D100 Module") || module.equals("D-Infinite Module")) {
            for (String mercenaryName : Mercenary.getMercenariesName()) {
                MercenaryPlayerData.resetMercenaryMissionReroll(playerData, mercenaryName);
            }
        }
    }

    public int getModuleColor(int row) {
        if (row < 2) {
            return 0xFFFFFF;
        }
        if (row < 4) {
            return 65280;
        }
        if (row < 6) {
            return 12543;
        }
        return 0xFF0000;
    }

    public String getMissingModuleItemsString(Player player) {
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("\nMissing Items :");
        boolean itemsMissing = false;
        for (MissionItem item : this.unlockItems) {
            int needed;
            int owned = Utils.countItemInInventory(item.itemStack.m_41720_(), player);
            if (owned >= (needed = item.number)) continue;
            itemsMissing = true;
            tooltip.append(String.format("\n- %d %s", needed - owned, item.getName()));
        }
        if (!itemsMissing) {
            return "";
        }
        return tooltip.toString();
    }

    public static Module getModule(String moduleName) {
        return moduleMap.get(moduleName);
    }

    public static Module getModule(int index) {
        return moduleArray.get(index);
    }

    public static Set<Map.Entry<String, Module>> getModules() {
        return moduleMap.entrySet();
    }

    public static void clearModules() {
        moduleArray.clear();
        moduleMap.clear();
    }

    public static void handleSleepingModuleEffect(SleepFinishedTimeEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            List<ServerPlayer> sleepingPlayers = serverLevel.m_6907_().stream().filter(LivingEntity::m_5803_).toList();
            for (ServerPlayer player : sleepingPlayers) {
                player.getCapability(PlayerCapability.PLAYER_DATA).ifPresent(cap -> {
                    PlayerData playerData = cap.getPlayerData();
                    if (Module.isModuleActive(playerData, "Sleeping Module")) {
                        boolean dataChanged = false;
                        for (String mercenaryName : Mercenary.getMercenariesName()) {
                            int currentTimeLeft;
                            if (MercenaryPlayerData.isMercenaryOnMission(playerData, mercenaryName) && (currentTimeLeft = playerData.missionTimeLeft.getOrDefault(mercenaryName, 0).intValue()) > 0) {
                                int newTimeLeft = Math.max(0, currentTimeLeft - 120);
                                playerData.missionTimeLeft.put(mercenaryName, newTimeLeft);
                                MercenaryPlayerData.setMercenaryMissionTimeLeft(playerData, mercenaryName, newTimeLeft);
                                if (newTimeLeft == 0) {
                                    MercenaryPlayerData.setMercenaryMissionTimerFinish(playerData, mercenaryName);
                                }
                                dataChanged = true;
                            }
                            if (mercenaryName.equals("Vael")) continue;
                            int currentHunger = MercenaryPlayerData.getMercenaryCurrentHunger(playerData, mercenaryName);
                            int maxHunger = MercenaryPlayerData.getMercenaryMaximumHunger(playerData, mercenaryName);
                            int newHunger = Math.min(maxHunger, currentHunger + 2);
                            MercenaryPlayerData.setMercenaryHunger(playerData, mercenaryName, newHunger);
                        }
                        if (dataChanged) {
                            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                                System.out.println("Reduced mission time for " + player.m_7755_().getString() + " due to sleeping.");
                            }
                            PacketHandler.sendToPlayer("AddMercenariesToMap", playerData, player);
                        }
                    }
                });
            }
        }
    }

    @Nullable
    public static ArrayList<String> missingPlayerModuleModulesRequirement(int moduleIndex, Player player) {
        PlayerData playerData = PlayerData.getPlayerData(player);
        if (playerData == null) {
            Admin.playerRequestError(player, "Player Data is null.");
            return null;
        }
        ArrayList<String> missingRequirements = new ArrayList<String>();
        Module module = Module.getModule(moduleIndex);
        if (Module.isModuleActive(playerData, module.name)) {
            return missingRequirements;
        }
        ArrayList<String> requirements = new ArrayList<String>(Arrays.asList(module.requirements));
        for (String moduleName : requirements) {
            if (moduleName.equals("None") || Module.isModuleActive(playerData, moduleName)) continue;
            missingRequirements.add(moduleName);
        }
        return missingRequirements;
    }

    public static boolean checkIfPlayerHasModuleItemRequirements(int moduleIndex, Player player, boolean isServerSide) {
        PlayerData playerData = PlayerData.getPlayerData((Player)(isServerSide ? player : null));
        if (playerData == null) {
            Admin.playerRequestError(player, "Player Data is null.");
            return false;
        }
        Module module = Module.getModule(moduleIndex);
        for (MissionItem missionItem : module.unlockItems) {
            if (Utils.hasEnoughItems(missionItem.itemStack.m_41720_(), player, missionItem.number)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkIfPlayerCanUnlockModule(int moduleIndex, Player player, boolean isServerSide) {
        PlayerData playerData = PlayerData.getPlayerData((Player)(isServerSide ? player : null));
        if (playerData == null) {
            Admin.playerRequestError(player, "Player Data is null.");
            return false;
        }
        Module module = Module.getModule(moduleIndex);
        if (Module.isModuleActive(playerData, module.name)) {
            return false;
        }
        ArrayList<String> requirements = new ArrayList<String>(Arrays.asList(module.requirements));
        boolean allRequirementsMet = true;
        while (!requirements.isEmpty()) {
            ArrayList<String> subRequirements = new ArrayList<String>();
            for (String moduleName : requirements) {
                if (moduleName.equals("None")) continue;
                if (!Module.isModuleActive(playerData, moduleName)) {
                    allRequirementsMet = false;
                    break;
                }
                Module subModule = Module.getModule(moduleName);
                subRequirements.addAll(new ArrayList<String>(Arrays.asList(subModule.requirements)));
            }
            requirements.clear();
            requirements.addAll(subRequirements);
        }
        if (!allRequirementsMet) {
            return false;
        }
        for (MissionItem missionItem : module.unlockItems) {
            if (Utils.hasEnoughItems(missionItem.itemStack.m_41720_(), player, missionItem.number)) continue;
            return false;
        }
        return true;
    }
}

