/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.module;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.sluggly.timemercenaries.module.Module;
import io.github.sluggly.timemercenaries.module.ModuleDefinition;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ModuleManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String DIRECTORY = "modules";
    private Map<ResourceLocation, ModuleDefinition> modules = new HashMap<ResourceLocation, ModuleDefinition>();
    private static final ModuleManager INSTANCE = new ModuleManager();

    public ModuleManager() {
        super(GSON, DIRECTORY);
    }

    public static ModuleManager getModuleManager() {
        return INSTANCE;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonObjects, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        HashMap<ResourceLocation, ModuleDefinition> loadedDefinitions = new HashMap<ResourceLocation, ModuleDefinition>();
        jsonObjects.forEach((location, jsonElement) -> {
            try {
                ModuleDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).resultOrPartial(error -> System.err.println("Failed to parse module " + String.valueOf(location) + ": " + error)).ifPresent(definition -> loadedDefinitions.put((ResourceLocation)location, (ModuleDefinition)definition));
            }
            catch (Exception e) {
                System.err.println("Exception while parsing module " + String.valueOf(location) + ": " + e.getMessage());
            }
        });
        this.setModules(loadedDefinitions);
    }

    public void setModules(@NotNull Map<ResourceLocation, ModuleDefinition> modules) {
        this.modules = modules;
        Module.clearModules();
        modules.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(ResourceLocation::m_135815_))).forEach(entry -> {
            ModuleDefinition def = (ModuleDefinition)entry.getValue();
            new Module(def);
        });
        System.out.println("Loaded " + this.modules.size() + " modules for Time Mercenaries.");
    }

    public Map<ResourceLocation, ModuleDefinition> getAllModules() {
        return this.modules;
    }
}

