/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.network;

import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.network.CtoSPacket;
import io.github.sluggly.timemercenaries.network.StoCPacket;
import io.github.sluggly.timemercenaries.network.SyncMercenariesPacket;
import io.github.sluggly.timemercenaries.network.SyncMissionsPacket;
import io.github.sluggly.timemercenaries.network.SyncModulesPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("timemercenaries", "main"), () -> "1", "1"::equals, "1"::equals);

    public static void register() {
        INSTANCE.messageBuilder(StoCPacket.class, 1).encoder(StoCPacket::encode).decoder(StoCPacket::new).consumerMainThread(StoCPacket::handle).add();
        INSTANCE.messageBuilder(CtoSPacket.class, 2).encoder(CtoSPacket::encode).decoder(CtoSPacket::new).consumerMainThread(CtoSPacket::handle).add();
        INSTANCE.messageBuilder(SyncMissionsPacket.class, 3, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncMissionsPacket::encode).decoder(SyncMissionsPacket::decode).consumerMainThread(SyncMissionsPacket::handle).add();
        INSTANCE.messageBuilder(SyncMercenariesPacket.class, 4, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncMercenariesPacket::encode).decoder(SyncMercenariesPacket::decode).consumerMainThread(SyncMercenariesPacket::handle).add();
        INSTANCE.messageBuilder(SyncModulesPacket.class, 5, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncModulesPacket::encode).decoder(SyncModulesPacket::decode).consumerMainThread(SyncModulesPacket::handle).add();
    }

    public static void sendToServer(CtoSPacket msg) {
        INSTANCE.sendToServer((Object)msg);
    }

    public static void sendToServer(String string) {
        CtoSPacket msg = new CtoSPacket(string);
        PacketHandler.sendToServer(msg);
    }

    public static void sendToServer(String string, CompoundTag data) {
        CtoSPacket msg = new CtoSPacket(string, data);
        PacketHandler.sendToServer(msg);
    }

    public static void sendToPlayer(StoCPacket msg, ServerPlayer player) {
        INSTANCE.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToPlayer(String action, PlayerData playerData, ServerPlayer player) {
        PacketHandler.sendToPlayer(action, playerData.getCompoundTag(), player);
    }

    public static void sendToPlayer(String action, CompoundTag customData, ServerPlayer player) {
        StoCPacket msg = new StoCPacket(action, customData);
        PacketHandler.sendToPlayer(msg, player);
    }

    public static <MSG> void sendToPlayer(MSG msg, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), msg);
    }
}

