/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.network;

import io.github.sluggly.timemercenaries.client.handler.ClientSyncHandler;
import io.github.sluggly.timemercenaries.missions.MissionDefinition;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record SyncMissionsPacket(Map<ResourceLocation, MissionDefinition> missions) {
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_236831_(this.missions, FriendlyByteBuf::m_130085_, (buf, def) -> buf.m_272073_(MissionDefinition.CODEC, def));
    }

    public static SyncMissionsPacket decode(FriendlyByteBuf buffer) {
        Map missions = buffer.m_236847_(FriendlyByteBuf::m_130281_, buf -> (MissionDefinition)buf.m_271872_(MissionDefinition.CODEC));
        return new SyncMissionsPacket(missions);
    }

    public static void handle(SyncMissionsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientSyncHandler.handleSyncMissions(msg)));
        ctx.get().setPacketHandled(true);
    }
}

