/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.network;

import io.github.sluggly.timemercenaries.client.handler.ClientSyncHandler;
import io.github.sluggly.timemercenaries.module.ModuleDefinition;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record SyncModulesPacket(Map<ResourceLocation, ModuleDefinition> modules) {
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_236831_(this.modules, FriendlyByteBuf::m_130085_, (buf, def) -> buf.m_272073_(ModuleDefinition.CODEC, def));
    }

    public static SyncModulesPacket decode(FriendlyByteBuf buffer) {
        Map modules = buffer.m_236847_(FriendlyByteBuf::m_130281_, buf -> (ModuleDefinition)buf.m_271872_(ModuleDefinition.CODEC));
        return new SyncModulesPacket(modules);
    }

    public static void handle(SyncModulesPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientSyncHandler.handleSyncModules(msg)));
        ctx.get().setPacketHandled(true);
    }
}

