/*
 * Decompiled with CFR 0.152.
 */
package winlyps.veinMiners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lwinlyps/veinMiners/VeinMiners;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "oreTypes", "", "Lorg/bukkit/Material;", "oreExpValues", "", "Lkotlin/ranges/IntRange;", "maxVeinSize", "", "random", "Ljava/util/Random;", "onEnable", "", "onDisable", "onBlockBreak", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "findConnectedOres", "", "Lorg/bukkit/block/Block;", "startBlock", "targetType", "givePlayerExperience", "player", "Lorg/bukkit/entity/Player;", "block", "hasSilkTouch", "", "item", "Lorg/bukkit/inventory/ItemStack;", "VeinMiners"})
public final class VeinMiners
extends JavaPlugin
implements Listener {
    @NotNull
    private final Set<Material> oreTypes;
    @NotNull
    private final Map<Material, IntRange> oreExpValues;
    private final int maxVeinSize;
    @NotNull
    private final Random random;

    public VeinMiners() {
        Object[] objectArray = new Material[]{Material.COAL_ORE, Material.IRON_ORE, Material.GOLD_ORE, Material.DIAMOND_ORE, Material.EMERALD_ORE, Material.LAPIS_ORE, Material.REDSTONE_ORE, Material.NETHER_QUARTZ_ORE, Material.NETHER_GOLD_ORE, Material.COPPER_ORE, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_COPPER_ORE};
        this.oreTypes = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)Material.COAL_ORE, (Object)new IntRange(0, 2)), TuplesKt.to((Object)Material.DEEPSLATE_COAL_ORE, (Object)new IntRange(0, 2)), TuplesKt.to((Object)Material.IRON_ORE, (Object)new IntRange(0, 1)), TuplesKt.to((Object)Material.DEEPSLATE_IRON_ORE, (Object)new IntRange(0, 1)), TuplesKt.to((Object)Material.COPPER_ORE, (Object)new IntRange(0, 2)), TuplesKt.to((Object)Material.DEEPSLATE_COPPER_ORE, (Object)new IntRange(0, 2)), TuplesKt.to((Object)Material.GOLD_ORE, (Object)new IntRange(0, 2)), TuplesKt.to((Object)Material.DEEPSLATE_GOLD_ORE, (Object)new IntRange(0, 2)), TuplesKt.to((Object)Material.REDSTONE_ORE, (Object)new IntRange(1, 5)), TuplesKt.to((Object)Material.DEEPSLATE_REDSTONE_ORE, (Object)new IntRange(1, 5)), TuplesKt.to((Object)Material.EMERALD_ORE, (Object)new IntRange(3, 7)), TuplesKt.to((Object)Material.DEEPSLATE_EMERALD_ORE, (Object)new IntRange(3, 7)), TuplesKt.to((Object)Material.LAPIS_ORE, (Object)new IntRange(2, 5)), TuplesKt.to((Object)Material.DEEPSLATE_LAPIS_ORE, (Object)new IntRange(2, 5)), TuplesKt.to((Object)Material.DIAMOND_ORE, (Object)new IntRange(3, 7)), TuplesKt.to((Object)Material.DEEPSLATE_DIAMOND_ORE, (Object)new IntRange(3, 7)), TuplesKt.to((Object)Material.NETHER_QUARTZ_ORE, (Object)new IntRange(2, 5)), TuplesKt.to((Object)Material.NETHER_GOLD_ORE, (Object)new IntRange(0, 1))};
        this.oreExpValues = MapsKt.mapOf((Pair[])objectArray);
        this.maxVeinSize = 64;
        this.random = new Random();
    }

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("VeinMiners has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("VeinMiners has been disabled!");
    }

    @EventHandler
    public final void onBlockBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        Block block2 = block;
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        ItemStack itemStack = player2.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
        ItemStack tool = itemStack;
        if (this.oreTypes.contains(block2.getType())) {
            Material material = block2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
            List<Block> blocksToMine = this.findConnectedOres(block2, material);
            List blocksToProcess = CollectionsKt.drop((Iterable)blocksToMine, (int)1);
            for (Block oreBlock : blocksToProcess) {
                BlockBreakEvent fakeEvent = new BlockBreakEvent(oreBlock, player2);
                this.getServer().getPluginManager().callEvent((Event)fakeEvent);
                if (fakeEvent.isCancelled()) continue;
                if (!this.hasSilkTouch(tool)) {
                    this.givePlayerExperience(player2, oreBlock);
                }
                if (this.hasSilkTouch(tool)) {
                    Material originalType;
                    Intrinsics.checkNotNullExpressionValue((Object)oreBlock.getType(), (String)"getType(...)");
                    oreBlock.setType(Material.AIR);
                    Item item = oreBlock.getWorld().dropItemNaturally(oreBlock.getLocation(), new ItemStack(originalType));
                    Intrinsics.checkNotNull((Object)item);
                    continue;
                }
                oreBlock.breakNaturally(tool);
            }
            this.getLogger().info("Vein miner processed " + blocksToMine.size() + " blocks");
        }
    }

    private final List<Block> findConnectedOres(Block startBlock, Material targetType) {
        HashSet<Block> visited = new HashSet<Block>();
        LinkedList<Block> queue = new LinkedList<Block>();
        ArrayList<Block> result = new ArrayList<Block>();
        queue.add(startBlock);
        visited.add(startBlock);
        result.add(startBlock);
        block0: while (!((Collection)queue).isEmpty() && result.size() < this.maxVeinSize) {
            Block current = (Block)queue.poll();
            for (int x = -1; x < 2; ++x) {
                for (int y = -1; y < 2; ++y) {
                    for (int z = -1; z < 2; ++z) {
                        Block adjacentBlock;
                        if (x == 0 && y == 0 && z == 0) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)current.getWorld().getBlockAt(current.getX() + x, current.getY() + y, current.getZ() + z), (String)"getBlockAt(...)");
                        if (adjacentBlock.getType() != targetType || visited.contains(adjacentBlock)) continue;
                        visited.add(adjacentBlock);
                        queue.add(adjacentBlock);
                        result.add(adjacentBlock);
                        if (result.size() >= this.maxVeinSize) break;
                    }
                    if (result.size() >= this.maxVeinSize) break;
                }
                if (result.size() >= this.maxVeinSize) continue block0;
            }
        }
        return result;
    }

    private final void givePlayerExperience(Player player, Block block) {
        int expAmount;
        IntRange intRange = this.oreExpValues.get(block.getType());
        if (intRange == null) {
            return;
        }
        IntRange expRange = intRange;
        int n = expAmount = expRange.getFirst() == expRange.getLast() ? expRange.getFirst() : this.random.nextInt(expRange.getLast() - expRange.getFirst() + 1) + expRange.getFirst();
        if (expAmount > 0) {
            player.giveExp(expAmount);
        }
    }

    private final boolean hasSilkTouch(ItemStack item) {
        if (item.getType() == Material.AIR) {
            return false;
        }
        return item.containsEnchantment(Enchantment.SILK_TOUCH);
    }
}

