/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.tmcraft.item;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.moves.categories.DamageCategory;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.List;
import java.util.Objects;
import kiwiapollo.tmcraft.common.DamageCategoryTextColorFactory;
import kiwiapollo.tmcraft.item.ElementalTypeItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MoveTeachingItem
extends class_1792
implements ElementalTypeItem,
PokemonSelectingItem {
    protected final String move;
    private final ElementalType type;

    public MoveTeachingItem(String move, ElementalType type) {
        super(new class_1792.class_1793());
        this.move = move;
        this.type = type;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (world.method_8608()) {
            return class_1271.method_22430((Object)itemStack);
        }
        return this.use((class_3222)player, itemStack);
    }

    protected abstract boolean canPokemonLearnMove(class_1657 var1, Pokemon var2);

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (this.getMoveTemplate().getDamageCategory() == DamageCategories.INSTANCE.getSTATUS()) {
            tooltip.add(this.getMoveTypeTooltipText());
            tooltip.add(this.getMoveDamageCategoryTooltipText());
        } else {
            tooltip.add(this.getMoveTypeTooltipText());
            tooltip.add(this.getMoveDamageCategoryTooltipText());
            tooltip.add(this.getMovePowerTooltipText());
        }
    }

    private class_2561 getMoveTypeTooltipText() {
        return this.type.getDisplayName().method_10862(class_2583.field_24360.method_36139(this.type.getHue()));
    }

    private class_2561 getMoveDamageCategoryTooltipText() {
        DamageCategory category = this.getMoveTemplate().getDamageCategory();
        class_2583 style = class_2583.field_24360.method_10977(new DamageCategoryTextColorFactory().create(category));
        return category.getDisplayName().method_27661().method_10862(style);
    }

    private class_2561 getMovePowerTooltipText() {
        class_2583 style = class_2583.field_24360.method_10977(class_124.field_1054);
        return class_2561.method_43470((String)String.valueOf(this.getMoveTemplate().getPower())).method_10862(style);
    }

    @Override
    public ElementalType getMoveType() {
        return this.type;
    }

    @NotNull
    private MoveTemplate getMoveTemplate() {
        Objects.requireNonNull(this.move);
        return Objects.requireNonNull(Moves.INSTANCE.getByName(this.move));
    }

    @Nullable
    public BagItem getBagItem() {
        return null;
    }

    @NotNull
    public class_1271<class_1799> use(@NotNull class_3222 player, @NotNull class_1799 itemStack) {
        return PokemonSelectingItem.DefaultImpls.use((PokemonSelectingItem)this, (class_3222)player, (class_1799)itemStack);
    }

    @Nullable
    public class_1271<class_1799> applyToPokemon(@NotNull class_3222 player, @NotNull class_1799 itemStack, @NotNull Pokemon pokemon) {
        if (!this.canPokemonLearnMove((class_1657)player, pokemon)) {
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15150, class_3419.field_15248, 1.0f, 1.0f);
            return class_1271.method_22430((Object)itemStack);
        }
        this.teachPokemonMove(pokemon);
        if (!player.method_7337()) {
            itemStack.method_7934(1);
        }
        player.method_43496((class_2561)class_2561.method_43469((String)"item.tmcraft.success.pokemon_learned_move", (Object[])new Object[]{pokemon.getDisplayName(), this.getMoveTemplate().getDisplayName()}));
        player.method_37908().method_8396(null, player.method_24515(), CobblemonSounds.PC_CLICK, class_3419.field_15248, 1.0f, 1.0f);
        return class_1271.method_22427((Object)itemStack);
    }

    private void teachPokemonMove(Pokemon pokemon) {
        if (pokemon.getMoveSet().hasSpace()) {
            pokemon.getMoveSet().add(this.getMoveTemplate().create());
        } else {
            pokemon.getBenchedMoves().add(new BenchedMove(this.getMoveTemplate(), 0));
        }
    }

    public void applyToBattlePokemon(@NotNull class_3222 player, @NotNull class_1799 itemStack, @NotNull BattlePokemon battlePokemon) {
        PokemonSelectingItem.DefaultImpls.applyToBattlePokemon((PokemonSelectingItem)this, (class_3222)player, (class_1799)itemStack, (BattlePokemon)battlePokemon);
    }

    public boolean canUseOnPokemon(@NotNull Pokemon pokemon) {
        return true;
    }

    public boolean canUseOnBattlePokemon(@NotNull BattlePokemon battlePokemon) {
        return false;
    }

    @NotNull
    public class_1271<class_1799> interactWithSpecificBattle(@NotNull class_3222 player, @NotNull class_1799 itemStack, @NotNull BattlePokemon battlePokemon) {
        return PokemonSelectingItem.DefaultImpls.interactWithSpecificBattle((PokemonSelectingItem)this, (class_3222)player, (class_1799)itemStack, (BattlePokemon)battlePokemon);
    }

    @NotNull
    public class_1271<class_1799> interactGeneral(@NotNull class_3222 player, @NotNull class_1799 itemStack) {
        return PokemonSelectingItem.DefaultImpls.interactGeneral((PokemonSelectingItem)this, (class_3222)player, (class_1799)itemStack);
    }

    @NotNull
    public class_1271<class_1799> interactGeneralBattle(@NotNull class_3222 player, @NotNull class_1799 itemStack, @NotNull BattleActor battleActor) {
        return PokemonSelectingItem.DefaultImpls.interactGeneralBattle((PokemonSelectingItem)this, (class_3222)player, (class_1799)itemStack, (BattleActor)battleActor);
    }
}

