/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.tmcraft.item.eggmove;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Collection;
import java.util.Objects;
import kiwiapollo.tmcraft.item.MoveTeachingItem;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class EggMoveTeachingItem
extends MoveTeachingItem {
    public EggMoveTeachingItem(String move, ElementalType type) {
        super(move, type);
    }

    @Override
    protected boolean canPokemonLearnMove(class_1657 player, Pokemon pokemon) {
        if (!this.isMoveExist()) {
            return false;
        }
        if (!this.isPokemonOwnedByPlayer(player, pokemon)) {
            return false;
        }
        if (!this.isPokemonLearnsetContainsMove(pokemon)) {
            player.method_43496((class_2561)class_2561.method_43469((String)"item.tmcraft.error.cannot_learn_move", (Object[])new Object[]{pokemon.getDisplayName(), this.getMoveTemplate().getDisplayName()}).method_27692(class_124.field_1061));
            return false;
        }
        if (this.isPokemonKnowsMove(pokemon)) {
            player.method_43496((class_2561)class_2561.method_43469((String)"item.tmcraft.error.pokemon_knows_move", (Object[])new Object[]{pokemon.getDisplayName(), this.getMoveTemplate().getDisplayName()}).method_27692(class_124.field_1061));
            return false;
        }
        return true;
    }

    private boolean isPokemonKnowsMove(Pokemon pokemon) {
        boolean isMoveSetMove = pokemon.getMoveSet().getMoves().stream().map(Move::getName).anyMatch(name -> name.equals(this.move));
        boolean isAccessibleMove = pokemon.getAllAccessibleMoves().stream().map(MoveTemplate::getName).anyMatch(name -> name.equals(this.move));
        return isMoveSetMove || isAccessibleMove;
    }

    private boolean isPokemonOwnedByPlayer(class_1657 player, Pokemon pokemon) {
        return player.equals((Object)pokemon.getOwnerPlayer());
    }

    private boolean isMoveExist() {
        try {
            this.getMoveTemplate();
            return true;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @NotNull
    private MoveTemplate getMoveTemplate() {
        Objects.requireNonNull(this.move);
        return Objects.requireNonNull(Moves.INSTANCE.getByName(this.move));
    }

    private boolean isPokemonLearnsetContainsMove(Pokemon pokemon) {
        boolean isLevelUpMove = pokemon.getForm().getMoves().getLevelUpMoves().values().stream().flatMap(Collection::stream).map(MoveTemplate::getName).toList().contains(this.move);
        boolean isEggMove = pokemon.getForm().getMoves().getEggMoves().stream().map(MoveTemplate::getName).toList().contains(this.move);
        return isLevelUpMove || isEggMove;
    }
}

