/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.tmcraft.item;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.moves.categories.DamageCategory;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kiwiapollo.tmcraft.common.TextColorMap;
import kiwiapollo.tmcraft.gamerule.ModGameRule;
import kiwiapollo.tmcraft.item.ElementalTypeItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1928;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public abstract class MoveTeachingItem
extends class_1792
implements ElementalTypeItem {
    private final String move;
    private final ElementalType type;
    private final String translation;

    public MoveTeachingItem(String move, ElementalType type, String translation) {
        super(new class_1792.class_1793());
        this.move = move;
        this.type = type;
        this.translation = translation;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (this.getMoveTemplate().getDamageCategory() == DamageCategories.INSTANCE.getSTATUS()) {
            tooltip.add(this.getMoveTypeTooltipText());
            tooltip.add(this.getMoveDamageCategoryTooltipText());
        } else {
            tooltip.add(this.getMoveTypeTooltipText());
            tooltip.add(this.getMoveDamageCategoryTooltipText());
            tooltip.add(this.getMovePowerTooltipText());
        }
    }

    private class_2561 getMoveTypeTooltipText() {
        return this.type.getDisplayName().method_10862(class_2583.field_24360.method_36139(this.type.getHue()));
    }

    private class_2561 getMoveDamageCategoryTooltipText() {
        DamageCategory category = this.getMoveTemplate().getDamageCategory();
        class_2583 style = class_2583.field_24360.method_10977(new TextColorMap().get(category));
        return category.getDisplayName().method_27661().method_10862(style);
    }

    private class_2561 getMovePowerTooltipText() {
        class_2583 style = class_2583.field_24360.method_10977(class_124.field_1054);
        return class_2561.method_43470((String)String.valueOf(this.getMoveTemplate().getPower())).method_10862(style);
    }

    @NotNull
    private MoveTemplate getMoveTemplate() {
        return Objects.requireNonNull(Moves.getByName((String)this.move));
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 class_16572 = context.method_8036();
        if (!(class_16572 instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 player = (class_3222)class_16572;
        if (player.method_37908().method_8608()) {
            return class_1269.field_5811;
        }
        player.method_43496((class_2561)this.method_7848().method_27661().method_27692(class_124.field_1054));
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
        for (int i = 0; i < party.size(); ++i) {
            Pokemon pokemon = party.get(i);
            player.method_43496((class_2561)class_2561.method_43470((String)String.format("[%d] ", i + 1)).method_10852(this.getMoveLearnStatus(pokemon)));
        }
        return class_1269.field_5812;
    }

    private class_2561 getMoveLearnStatus(Pokemon pokemon) {
        if (Objects.isNull(pokemon)) {
            return class_2561.method_43471((String)"item.tmcraft.move_learn_status.empty").method_27692(class_124.field_1080);
        }
        if (this.isPokemonAlreadyLearnedMove(pokemon)) {
            return pokemon.getDisplayName(false).method_10852((class_2561)class_2561.method_43470((String)", ")).method_10852((class_2561)class_2561.method_43471((String)"item.tmcraft.move_learn_status.learned").method_27692(class_124.field_1054));
        }
        if (this.isPokemonAbleToLearnMove(pokemon)) {
            return pokemon.getDisplayName(false).method_10852((class_2561)class_2561.method_43470((String)", ")).method_10852((class_2561)class_2561.method_43471((String)"item.tmcraft.move_learn_status.able").method_27692(class_124.field_1060));
        }
        return pokemon.getDisplayName(false).method_10852((class_2561)class_2561.method_43470((String)", ")).method_10852((class_2561)class_2561.method_43471((String)"item.tmcraft.move_learn_status.unable").method_27692(class_124.field_1061));
    }

    public class_1269 method_7847(class_1799 itemStack, class_1657 user, class_1309 entity, class_1268 hand) {
        if (user.method_37908().method_8608()) {
            return class_1269.field_5811;
        }
        if (!(user instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 player = (class_3222)user;
        if (!(entity instanceof PokemonEntity)) {
            return class_1269.field_5811;
        }
        Pokemon pokemon = ((PokemonEntity)entity).getPokemon();
        if (!this.isMoveExist()) {
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15150, class_3419.field_15248, 1.0f, 1.0f);
            return class_1269.field_5811;
        }
        if (!this.isPokemonOwnedByPlayer((class_1657)player, pokemon)) {
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15150, class_3419.field_15248, 1.0f, 1.0f);
            return class_1269.field_5811;
        }
        if (this.isPokemonAlreadyLearnedMove(pokemon)) {
            player.method_43496((class_2561)class_2561.method_43469((String)"item.tmcraft.error.already_learned_move", (Object[])new Object[]{pokemon.getDisplayName(false), this.getMoveTemplate().getDisplayName()}).method_27692(class_124.field_1061));
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15150, class_3419.field_15248, 1.0f, 1.0f);
            return class_1269.field_5811;
        }
        if (!this.isPokemonAbleToLearnMove(pokemon)) {
            player.method_43496((class_2561)class_2561.method_43469((String)"item.tmcraft.error.cannot_learn_move", (Object[])new Object[]{pokemon.getDisplayName(false), this.getMoveTemplate().getDisplayName()}).method_27692(class_124.field_1061));
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15150, class_3419.field_15248, 1.0f, 1.0f);
            return class_1269.field_5811;
        }
        this.teachMoveToPokemon(pokemon);
        if (this.shouldConsumeItemByGameRule(player.method_51469()) && !player.method_7337()) {
            itemStack.method_7934(1);
        }
        player.method_43496((class_2561)class_2561.method_43469((String)"item.tmcraft.success.pokemon_learned_move", (Object[])new Object[]{pokemon.getDisplayName(false), this.getMoveTemplate().getDisplayName()}));
        player.method_37908().method_8396(null, player.method_24515(), CobblemonSounds.PC_CLICK, class_3419.field_15248, 1.0f, 1.0f);
        return class_1269.field_5812;
    }

    private void teachMoveToPokemon(Pokemon pokemon) {
        if (pokemon.getMoveSet().hasSpace()) {
            pokemon.getMoveSet().add(this.getMoveTemplate().create());
        } else {
            pokemon.getBenchedMoves().add(new BenchedMove(this.getMoveTemplate(), 0));
        }
    }

    private boolean isMoveExist() {
        try {
            this.getMoveTemplate();
            return true;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private boolean isPokemonAlreadyLearnedMove(Pokemon pokemon) {
        return this.isMoveSetMove(pokemon) || this.isAccessibleMove(pokemon);
    }

    private boolean isMoveSetMove(Pokemon pokemon) {
        return pokemon.getMoveSet().getMoves().stream().map(Move::getName).anyMatch(name -> name.equals(this.move));
    }

    private boolean isAccessibleMove(Pokemon pokemon) {
        return pokemon.getAllAccessibleMoves().stream().map(MoveTemplate::getName).anyMatch(name -> name.equals(this.move));
    }

    protected boolean isLearnedByLevelUp(Pokemon pokemon) {
        return pokemon.getForm().getMoves().getLevelUpMoves().values().stream().flatMap(Collection::stream).map(MoveTemplate::getName).toList().contains(this.move);
    }

    protected boolean isLearnedByTM(Pokemon pokemon) {
        return pokemon.getForm().getMoves().getTmMoves().stream().map(MoveTemplate::getName).toList().contains(this.move);
    }

    protected boolean isLearnedByMoveTutor(Pokemon pokemon) {
        return pokemon.getForm().getMoves().getTutorMoves().stream().map(MoveTemplate::getName).toList().contains(this.move);
    }

    protected boolean isLearnedByBreeding(Pokemon pokemon) {
        return pokemon.getForm().getMoves().getEggMoves().stream().map(MoveTemplate::getName).toList().contains(this.move);
    }

    private boolean isPokemonOwnedByPlayer(class_1657 player, Pokemon pokemon) {
        return player.equals((Object)pokemon.getOwnerPlayer());
    }

    protected abstract boolean isPokemonAbleToLearnMove(Pokemon var1);

    private boolean shouldConsumeItemByGameRule(class_3218 world) {
        try {
            return ((class_1928.class_4310)world.method_8450().method_20746(ModGameRule.CONSUME_MOVE_ITEM_ON_USE)).method_20753();
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        if (class_2477.method_10517().method_4678(super.method_7876())) {
            return super.method_7864(stack);
        }
        MoveTemplate m = Moves.getByName((String)this.move);
        return class_2561.method_43469((String)this.translation, (Object[])new Object[]{m.getNum(), m.getDisplayName()});
    }

    public class_2561 method_7848() {
        if (class_2477.method_10517().method_4678(super.method_7876())) {
            return super.method_7848();
        }
        MoveTemplate m = Moves.getByName((String)this.move);
        return class_2561.method_43469((String)this.translation, (Object[])new Object[]{m.getNum(), m.getDisplayName()});
    }

    @Override
    public ElementalType getMoveType() {
        return this.type;
    }
}

