/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.tmcraft.datagen;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kiwiapollo.tmcraft.datagen.BlankDiscRecipeGenerator;
import kiwiapollo.tmcraft.datagen.BlockTagProvider;
import kiwiapollo.tmcraft.datagen.LootTableProvider;
import kiwiapollo.tmcraft.datagen.ModTagRegistry;
import kiwiapollo.tmcraft.datagen.MoveTutorTableRecipeGenerator;
import kiwiapollo.tmcraft.datagen.PoiTagProvider;
import kiwiapollo.tmcraft.datagen.PokemonBreederTableRecipeGenerator;
import kiwiapollo.tmcraft.datagen.SmithingTemplateRecipeGenerator;
import kiwiapollo.tmcraft.datagen.TMRecipeGenerator;
import kiwiapollo.tmcraft.item.eggmove.EggMoveItem;
import kiwiapollo.tmcraft.item.misc.BlankBookItem;
import kiwiapollo.tmcraft.item.misc.BlankDiscItem;
import kiwiapollo.tmcraft.item.misc.BlankEggItem;
import kiwiapollo.tmcraft.item.tmmove.TMMoveItem;
import kiwiapollo.tmcraft.item.tutormove.TutorMoveItem;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2444;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class DataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(RecipeProvider::new);
        pack.addProvider(ItemTagProvider::new);
        pack.addProvider(PoiTagProvider::new);
        pack.addProvider(BlockTagProvider::new);
        pack.addProvider(LootTableProvider::new);
    }

    private static class ItemTagProvider
    extends FabricTagProvider<class_1792> {
        public ItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, class_7924.field_41197, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 arg) {
            Arrays.stream(TMMoveItem.values()).forEach(item -> this.getOrCreateTagBuilder(ModTagRegistry.TM_MOVES).add((Object)item.getItem()));
            Arrays.stream(EggMoveItem.values()).forEach(item -> this.getOrCreateTagBuilder(ModTagRegistry.EGG_MOVES).add((Object)item.getItem()));
            Arrays.stream(TutorMoveItem.values()).forEach(item -> this.getOrCreateTagBuilder(ModTagRegistry.TUTOR_MOVES).add((Object)item.getItem()));
            Arrays.stream(TutorMoveItem.values()).forEach(item -> this.getOrCreateTagBuilder(ModTagRegistry.STAR_MOVES).add((Object)item.getItem()));
            Arrays.stream(BlankDiscItem.values()).forEach(item -> this.getOrCreateTagBuilder(ModTagRegistry.BLANK_DISCS).add((Object)item.getItem()));
            Arrays.stream(BlankEggItem.values()).forEach(item -> this.getOrCreateTagBuilder(ModTagRegistry.BLANK_EGGS).add((Object)item.getItem()));
            Arrays.stream(BlankBookItem.values()).forEach(item -> this.getOrCreateTagBuilder(ModTagRegistry.BLANK_BOOKS).add((Object)item.getItem()));
            Arrays.stream(BlankBookItem.values()).forEach(item -> this.getOrCreateTagBuilder(ModTagRegistry.BLANK_STARS).add((Object)item.getItem()));
        }
    }

    private static class RecipeProvider
    extends FabricRecipeProvider {
        public RecipeProvider(FabricDataOutput output) {
            super(output);
        }

        public void method_10419(Consumer<class_2444> exporter) {
            new TMRecipeGenerator().generate(exporter);
            new BlankDiscRecipeGenerator().generate(exporter);
            new SmithingTemplateRecipeGenerator().generate(exporter);
            new MoveTutorTableRecipeGenerator().generate(exporter);
            new PokemonBreederTableRecipeGenerator().generate(exporter);
        }
    }
}

