/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.illwalls.entity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2604;
import net.minecraft.class_3730;
import net.minecraft.class_638;
import org.slf4j.Logger;
import work.lclpnet.illwalls.entity.ExtraSpawnData;
import work.lclpnet.illwalls.network.EntityExtraSpawnS2CPacket;
import work.lclpnet.illwalls.network.StructureUpdateS2CPacket;
import work.lclpnet.illwalls.struct.StructureContainer;
import work.lclpnet.illwalls.struct.StructureHolder;

@Environment(value=EnvType.CLIENT)
public class ClientEntityManager {
    private final Logger logger;

    public ClientEntityManager(Logger logger) {
        this.logger = logger;
    }

    public void spawnEntity(EntityExtraSpawnS2CPacket extraPacket, class_638 world) {
        class_2604 packet = extraPacket.packet();
        class_1299 entityType = packet.method_11169();
        class_1297 entity = entityType.method_5883((class_1937)world, class_3730.field_52444);
        if (entity == null) {
            this.logger.warn("Skipping entity with id {}", (Object)entityType);
            return;
        }
        entity.method_31471(packet);
        if (entity instanceof ExtraSpawnData) {
            ExtraSpawnData extraSpawnData = (ExtraSpawnData)entity;
            class_2540 data = extraPacket.data();
            extraSpawnData.readExtraSpawnData(data);
        }
        entity.method_5838(packet.method_11167());
        world.method_53875(entity);
    }

    public void updateIllusoryWall(StructureUpdateS2CPacket packet, class_638 world) {
        int entityId = packet.entityId();
        class_1297 entity = world.method_8469(entityId);
        if (!(entity instanceof StructureHolder)) {
            this.logger.warn("Skipping invalid illusory wall update for id {}", (Object)entityId);
            return;
        }
        StructureHolder holder = (StructureHolder)entity;
        StructureContainer structureContainer = holder.getStructureContainer();
        structureContainer.updateStructure(packet.deltaStructure());
    }
}

