/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.illwalls.entity;

import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5819;
import net.minecraft.class_6677;
import net.minecraft.class_8113;
import work.lclpnet.illwalls.IllusoryWallsMod;
import work.lclpnet.illwalls.entity.EntityConditionalTracking;
import work.lclpnet.illwalls.entity.ExtraSpawnData;
import work.lclpnet.illwalls.network.EntityExtraSpawnS2CPacket;
import work.lclpnet.illwalls.network.IllusoryWallsPacketCodecs;
import work.lclpnet.illwalls.network.ServerNetworkHandler;
import work.lclpnet.illwalls.struct.ExtendedBlockStateAdapter;
import work.lclpnet.illwalls.struct.ExtendedStructureWrapper;
import work.lclpnet.illwalls.struct.StructureContainer;
import work.lclpnet.illwalls.struct.StructureHolder;
import work.lclpnet.illwalls.util.ColorUtil;
import work.lclpnet.illwalls.util.PlayerInfo;
import work.lclpnet.illwalls.wall.IllusoryWallProperties;
import work.lclpnet.kibu.jnbt.CompoundTag;
import work.lclpnet.kibu.jnbt.Tag;
import work.lclpnet.kibu.mc.BlockStateAdapter;
import work.lclpnet.kibu.nbt.FabricNbtConversion;
import work.lclpnet.kibu.schematic.api.SchematicWriteable;
import work.lclpnet.kibu.structure.BlockStructure;

public class IllusoryWallEntity
extends class_1297
implements EntityConditionalTracking,
ExtraSpawnData,
StructureHolder {
    public static final String FADING_NBT_KEY = "fading";
    public static final String STRUCTURE_NBT_KEY = "structure";
    public static final String PROPERTIES_NBT_KEY = "properties";
    public static final String FADE_MODE_NBT_KEY = "fade_mode";
    public static final String FADE_FROM_NBT_KEY = "fade_from";
    public static final int FADE_DURATION_TICKS = 20;
    public static final int FADE_DURATION_MS = 1000;
    public static final int FADE_OUT = 0;
    public static final int FADE_IN = 1;
    private boolean fading = false;
    private int fadeMode = 0;
    private transient int fadeEnd = 0;
    private class_2338 fadeFrom = null;
    private final StructureContainer structureContainer = new StructureContainer(this);
    private final IllusoryWallProperties properties = new IllusoryWallProperties();
    @Environment(value=EnvType.CLIENT)
    private int outlineColor;

    public IllusoryWallEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        if (this.method_73183().method_8608()) {
            this.initClient();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void initClient() {
        class_6677 colorRandom = new class_6677((long)this.method_5628());
        int hsvColor = ColorUtil.getRandomHsvColor((class_5819)colorRandom);
        this.outlineColor = ColorUtil.setArgbPackedAlpha(hsvColor, 255);
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public boolean isFading() {
        return this.fading;
    }

    public void setFading(boolean fading) {
        this.fading = fading;
        if (fading) {
            this.fadeEnd = this.field_6012 + 20;
        }
    }

    protected void method_5749(class_11368 view) {
        this.setFading(view.method_71433(FADING_NBT_KEY, false));
        class_2487 structureNbt = view.method_71426(STRUCTURE_NBT_KEY, class_2487.field_25128).orElseGet(class_2487::new);
        CompoundTag structureTag = (CompoundTag)FabricNbtConversion.convert((class_2520)structureNbt, CompoundTag.class);
        ExtendedBlockStateAdapter adapter = ExtendedBlockStateAdapter.getInstance();
        BlockStructure structure = IllusoryWallsMod.SCHEMATIC_FORMAT.deserializer().deserialize(structureTag, (BlockStateAdapter)adapter, StructureContainer::createMutableStructure);
        this.structureContainer.setStructure(structure);
        this.properties.readFrom(view.method_71434(PROPERTIES_NBT_KEY));
        this.setFadeMode(view.method_71424(FADE_MODE_NBT_KEY, 0));
        this.fadeFrom = class_2338.method_10092((long)view.method_71425(FADE_FROM_NBT_KEY, 0L));
    }

    protected void method_5652(class_11372 nbt) {
        nbt.method_71472(FADING_NBT_KEY, this.isFading());
        BlockStructure structure = this.structureContainer.getWrapper().getStructure();
        CompoundTag structureTag = IllusoryWallsMod.SCHEMATIC_FORMAT.serializer().serialize((SchematicWriteable)structure);
        class_2487 structureNbt = (class_2487)FabricNbtConversion.convert((Tag)structureTag, class_2487.class);
        nbt.method_71468(STRUCTURE_NBT_KEY, class_2487.field_25128, (Object)structureNbt);
        this.getIllusoryWallProperties().writeTo(nbt.method_71461(PROPERTIES_NBT_KEY));
        nbt.method_71465(FADE_MODE_NBT_KEY, this.getFadeMode());
        if (this.fadeFrom != null) {
            nbt.method_71466(FADE_FROM_NBT_KEY, this.fadeFrom.method_10063());
        }
    }

    @Override
    public StructureContainer getStructureContainer() {
        return this.structureContainer;
    }

    @Override
    public boolean shouldBeTrackedBy(class_3222 player) {
        return PlayerInfo.get(player).canSeeIllusoryWalls();
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        EntityExtraSpawnS2CPacket packet = new EntityExtraSpawnS2CPacket(this, entityTrackerEntry);
        return ServerNetworkHandler.createS2CPacket(packet);
    }

    @Override
    public void writeExtraSpawnData(class_2540 buf) {
        IllusoryWallsPacketCodecs.STRUCTURE_PACKET_CODEC.encode((Object)buf, (Object)this.structureContainer.getWrapper().getStructure());
    }

    @Override
    public void readExtraSpawnData(class_2540 buf) {
        BlockStructure structure = (BlockStructure)IllusoryWallsPacketCodecs.STRUCTURE_PACKET_CODEC.decode((Object)buf);
        this.structureContainer.setStructure(structure);
    }

    public synchronized void fade(@Nullable class_2338 from) {
        class_1937 world = this.method_73183();
        if (world.method_8608() || this.isFading()) {
            return;
        }
        this.fadeFrom = from;
        for (class_2338 pos : this.structureContainer.getWrapper().getBlockPositions()) {
            world.method_8501(pos, class_2246.field_10124.method_9564());
        }
        class_2338 pos = this.method_24515();
        class_243 soundPos = pos.method_46558();
        world.method_43128(null, soundPos.method_10216(), soundPos.method_10214(), soundPos.method_10215(), IllusoryWallsMod.ILLUSORY_WALL_FADE_SOUND, class_3419.field_15245, 0.85f, 1.0f);
        this.setFading(true);
        this.setFadeMode(0);
        class_3218 serverWorld = (class_3218)world;
        this.spawnStructureEntity(pos, serverWorld, 0);
    }

    public synchronized void resetWall() {
        if (this.method_31481()) {
            return;
        }
        class_1937 world = this.method_73183();
        if (world.method_8608() || this.isFading() && this.getFadeMode() == 1) {
            return;
        }
        this.properties.stopRespawnTimer();
        class_2338 pos = this.method_24515();
        class_243 soundPos = pos.method_46558();
        world.method_43128(null, soundPos.method_10216(), soundPos.method_10214(), soundPos.method_10215(), IllusoryWallsMod.ILLUSORY_WALL_FADE_SOUND, class_3419.field_15245, 0.85f, 1.0f);
        this.setFading(true);
        this.setFadeMode(1);
        class_3218 serverWorld = (class_3218)world;
        this.spawnStructureEntity(pos, serverWorld, 1);
    }

    private void replaceBlocks() {
        class_1937 world = this.method_73183();
        if (world.method_8608()) {
            return;
        }
        ExtendedStructureWrapper wrapper = this.structureContainer.getWrapper();
        for (class_2338 pos : wrapper.getBlockPositions()) {
            world.method_8501(pos, wrapper.method_8320(pos));
        }
    }

    private void spawnStructureEntity(class_2338 pos, class_3218 serverWorld, int fadeIn) {
        IllusoryWallsMod.STRUCTURE_ENTITY.method_5899(serverWorld, entity -> {
            this.structureContainer.getWrapper().copyTo(entity.getStructureContainer().getWrapper());
            entity.setFading(true);
            entity.setFadeMode(fadeIn);
            entity.setFadingFrom(this.fadeFrom != null ? this.fadeFrom : pos);
        }, pos, class_3730.field_16468, false, false);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_73183().method_8608() || !this.isFading() || this.field_6012 < this.fadeEnd) {
            return;
        }
        if (this.getFadeMode() != 0) {
            this.setFading(false);
            if (this.fadeMode == 1) {
                this.replaceBlocks();
            }
            return;
        }
        if (!this.properties.shouldRespawn()) {
            this.method_31472();
            return;
        }
        if (!this.properties.isRespawnTimerActive()) {
            this.properties.startRespawnTimer();
        }
        if (this.properties.tickTimer()) {
            this.resetWall();
        }
    }

    public boolean method_5640(double distance) {
        return distance < class_3532.method_33723((double)(64.0 * class_8113.method_5824()));
    }

    @Environment(value=EnvType.CLIENT)
    public int getOutlineColor() {
        return this.outlineColor;
    }

    public int getFadeMode() {
        return this.fadeMode;
    }

    public void setFadeMode(int fadeMode) {
        this.fadeMode = fadeMode;
    }

    public IllusoryWallProperties getIllusoryWallProperties() {
        return this.properties;
    }

    public final boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return false;
    }
}

