/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.illwalls.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3532;
import net.minecraft.class_8113;
import work.lclpnet.illwalls.IllusoryWallsMod;
import work.lclpnet.illwalls.entity.ExtraSpawnData;
import work.lclpnet.illwalls.network.EntityExtraSpawnS2CPacket;
import work.lclpnet.illwalls.network.IllusoryWallsPacketCodecs;
import work.lclpnet.illwalls.network.ServerNetworkHandler;
import work.lclpnet.illwalls.struct.ExtendedBlockStateAdapter;
import work.lclpnet.illwalls.struct.StructureContainer;
import work.lclpnet.illwalls.struct.StructureHolder;
import work.lclpnet.kibu.jnbt.CompoundTag;
import work.lclpnet.kibu.jnbt.Tag;
import work.lclpnet.kibu.mc.BlockStateAdapter;
import work.lclpnet.kibu.nbt.FabricNbtConversion;
import work.lclpnet.kibu.schematic.api.SchematicWriteable;
import work.lclpnet.kibu.structure.BlockStructure;

public class StructureEntity
extends class_1297
implements ExtraSpawnData,
StructureHolder {
    public static final String FADING_NBT_KEY = "fading";
    public static final String VIEW_RANGE_NBT_KEY = "view_range";
    public static final String STRUCTURE_NBT_KEY = "structure";
    public static final String FADE_MODE_NBT_KEY = "fade_mode";
    public static final int FADE_OUT = 0;
    public static final int FADE_IN = 1;
    private static final class_2940<Boolean> FADING = class_2945.method_12791(StructureEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> VIEW_RANGE = class_2945.method_12791(StructureEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Optional<class_2338>> FADING_FROM = class_2945.method_12791(StructureEntity.class, (class_2941)class_2943.field_13315);
    private transient int fadeEnd = 0;
    @Environment(value=EnvType.CLIENT)
    private transient long fadeStartMs;
    private final StructureContainer structureContainer = new StructureContainer(this);
    private int fadeMode = 0;

    public StructureEntity(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
        if (world.method_8608()) {
            this.initClient();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void initClient() {
        this.fadeStartMs = 0L;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(FADING, (Object)false).method_56912(VIEW_RANGE, (Object)Float.valueOf(1.0f)).method_56912(FADING_FROM, Optional.empty());
    }

    public boolean isFading() {
        return (Boolean)this.field_6011.method_12789(FADING);
    }

    public void setFading(boolean fading) {
        boolean wasFading = this.isFading();
        this.field_6011.method_12778(FADING, (Object)fading);
        if (!wasFading && fading) {
            this.startFading();
        }
    }

    public int getFadeMode() {
        return this.fadeMode;
    }

    public void setFadeMode(int fadeMode) {
        this.fadeMode = fadeMode;
    }

    @Nullable
    public class_2338 getFadingFrom() {
        return ((Optional)this.field_6011.method_12789(FADING_FROM)).orElse(null);
    }

    public void setFadingFrom(@Nullable class_2338 pos) {
        this.field_6011.method_12778(FADING_FROM, Optional.ofNullable(pos));
    }

    private void startFading() {
        this.fadeEnd = this.field_6012 + 20;
        if (this.method_73183().method_8608()) {
            this.fadeStartMs = System.currentTimeMillis();
        }
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (data.equals(FADING) && this.isFading()) {
            this.startFading();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public long getFadeStartMs() {
        return this.fadeStartMs;
    }

    protected void method_5749(class_11368 view) {
        this.setFading(view.method_71433(FADING_NBT_KEY, false));
        this.setViewRange(view.method_71423(VIEW_RANGE_NBT_KEY, 0.0f));
        class_2487 structureNbt = view.method_71426(STRUCTURE_NBT_KEY, class_2487.field_25128).orElseGet(class_2487::new);
        CompoundTag structureTag = (CompoundTag)FabricNbtConversion.convert((class_2520)structureNbt, CompoundTag.class);
        ExtendedBlockStateAdapter adapter = ExtendedBlockStateAdapter.getInstance();
        BlockStructure structure = IllusoryWallsMod.SCHEMATIC_FORMAT.deserializer().deserialize(structureTag, (BlockStateAdapter)adapter, StructureContainer::createMutableStructure);
        this.structureContainer.setStructure(structure);
        this.fadeMode = view.method_71424(FADE_MODE_NBT_KEY, 0);
    }

    protected void method_5652(class_11372 view) {
        view.method_71472(FADING_NBT_KEY, this.isFading());
        view.method_71464(VIEW_RANGE_NBT_KEY, this.getViewRange());
        BlockStructure structure = this.structureContainer.getWrapper().getStructure();
        CompoundTag structureTag = IllusoryWallsMod.SCHEMATIC_FORMAT.serializer().serialize((SchematicWriteable)structure);
        class_2487 structureNbt = (class_2487)FabricNbtConversion.convert((Tag)structureTag, class_2487.class);
        view.method_71468(STRUCTURE_NBT_KEY, class_2487.field_25128, (Object)structureNbt);
        view.method_71465(FADE_MODE_NBT_KEY, this.fadeMode);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_73183().method_8608() || !this.isFading() || this.field_6012 < this.fadeEnd + 2) {
            return;
        }
        this.method_31472();
    }

    @Override
    public StructureContainer getStructureContainer() {
        return this.structureContainer;
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        EntityExtraSpawnS2CPacket packet = new EntityExtraSpawnS2CPacket(this, entityTrackerEntry);
        return ServerNetworkHandler.createS2CPacket(packet);
    }

    @Override
    public void writeExtraSpawnData(class_2540 buf) {
        IllusoryWallsPacketCodecs.STRUCTURE_PACKET_CODEC.encode((Object)buf, (Object)this.structureContainer.getWrapper().getStructure());
        buf.method_52964(this.isFading());
        buf.method_10807(this.getFadingFrom());
        buf.method_10804(this.getFadeMode());
    }

    @Override
    public void readExtraSpawnData(class_2540 buf) {
        BlockStructure structure = (BlockStructure)IllusoryWallsPacketCodecs.STRUCTURE_PACKET_CODEC.decode((Object)buf);
        this.structureContainer.setStructure(structure);
        this.setFading(buf.readBoolean());
        this.setFadingFrom(buf.method_10811());
        this.setFadeMode(buf.method_10816());
    }

    private float getViewRange() {
        return ((Float)this.field_6011.method_12789(VIEW_RANGE)).floatValue();
    }

    private void setViewRange(float viewRange) {
        this.field_6011.method_12778(VIEW_RANGE, (Object)Float.valueOf(viewRange));
    }

    public boolean method_5640(double distance) {
        return distance < class_3532.method_33723((double)((double)this.getViewRange() * 64.0 * class_8113.method_5824()));
    }

    public final boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return false;
    }
}

