/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.illwalls.event;

import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import work.lclpnet.illwalls.IllusoryWallsApi;
import work.lclpnet.illwalls.IllusoryWallsMod;
import work.lclpnet.illwalls.item.StaffOfIllusionItem;
import work.lclpnet.illwalls.util.PlayerInfo;
import work.lclpnet.illwalls.wall.IllusoryWallLookup;
import work.lclpnet.illwalls.wall.IllusoryWallManager;
import work.lclpnet.kibu.hook.entity.ProjectileHooks;
import work.lclpnet.kibu.hook.player.PlayerGameModeChangeCallback;
import work.lclpnet.kibu.hook.player.PlayerInventoryHooks;
import work.lclpnet.kibu.hook.world.BlockModificationHooks;

public class ModEventListener {
    private final IllusoryWallManager wallManager;
    private final IllusoryWallLookup wallLookup;

    public ModEventListener(IllusoryWallManager wallManager, IllusoryWallLookup wallLookup) {
        this.wallManager = wallManager;
        this.wallLookup = wallLookup;
    }

    public void register() {
        this.registryEvents();
        this.registerEditWallEvents();
        this.registerDestroyWallEvents();
        this.preventWallModification();
        this.registerStaffHeldEvents();
    }

    private void registerEditWallEvents() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_1269 result;
            class_2338 pos = hitResult.method_17777();
            if (player == null || !player.method_5998(hand).method_31574((class_1792)IllusoryWallsMod.STAFF_OF_ILLUSION_ITEM)) {
                return class_1269.field_5811;
            }
            if (!world.method_8608() && pos != null && (result = StaffOfIllusionItem.onRightClickBlockEarlyServer((class_3222)player, (class_3218)world, pos)) != null) {
                return result;
            }
            return class_1269.field_5812;
        });
    }

    private void registryEvents() {
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41063).register(entries -> {
            if (!entries.getContext().comp_1252()) {
                return;
            }
            entries.method_45421((class_1935)IllusoryWallsMod.STAFF_OF_ILLUSION_ITEM);
        });
    }

    private void preventWallModification() {
        BlockModificationHooks.PLACE_BLOCK.register((world, pos, entity, newState) -> {
            if (world.method_8608() || !(world instanceof class_3218)) {
                return false;
            }
            class_3218 serverWorld = (class_3218)world;
            return this.wallLookup.getWallAt(serverWorld, pos).isPresent();
        });
        BlockModificationHooks.PLACE_FLUID.register((world, pos, entity, newState) -> {
            if (world.method_8608() || !(world instanceof class_3218)) {
                return false;
            }
            class_3218 serverWorld = (class_3218)world;
            return this.wallLookup.getWallAt(serverWorld, pos).isPresent();
        });
    }

    private void registerDestroyWallEvents() {
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (world.method_8608() || hand != class_1268.field_5808) {
                return class_1269.field_5811;
            }
            class_1799 stack = player.method_5998(hand);
            if (stack.method_31574((class_1792)IllusoryWallsMod.STAFF_OF_ILLUSION_ITEM)) {
                return class_1269.field_5811;
            }
            class_2338 from = pos.method_10093(direction);
            boolean success = this.wallManager.fadeWallAtIfPresent((class_3218)world, pos, from);
            return success ? class_1269.field_21466 : class_1269.field_5811;
        });
        ProjectileHooks.HIT_BLOCK.register((projectile, hit) -> {
            if (projectile.method_73183().method_8608()) {
                return;
            }
            class_2338 pos = hit.method_17777();
            IllusoryWallManager manager = IllusoryWallsApi.getInstance().manager();
            class_2338 from = pos.method_10093(hit.method_17780());
            manager.fadeWallAtIfPresent((class_3218)projectile.method_73183(), pos, from);
        });
    }

    private void registerStaffHeldEvents() {
        PlayerInventoryHooks.SLOT_CHANGE.register((player, slot) -> PlayerInfo.get(player).updatePlayerCanSeeIllusoryWalls());
        PlayerGameModeChangeCallback.HOOK.register((player, gameMode) -> PlayerInfo.get(player).updatePlayerCanSeeIllusoryWalls());
        PlayerInventoryHooks.MODIFY_CREATIVE_INVENTORY.register(event -> {
            class_3222 player = event.player();
            int handlerSlotIdx = event.slot();
            if (handlerSlotIdx < 1 || handlerSlotIdx > 45) {
                return;
            }
            class_1735 handlerSlot = player.field_7512.method_7611(handlerSlotIdx);
            if (handlerSlot == null) {
                return;
            }
            int slot = handlerSlot.method_34266();
            if (player.method_31548().method_67532() != slot) {
                return;
            }
            class_1799 handStack = event.stack();
            if (handStack.method_31574((class_1792)IllusoryWallsMod.STAFF_OF_ILLUSION_ITEM)) {
                PlayerInfo.get(player).setCanSeeIllusoryWalls(true);
                return;
            }
            class_1799 stack = player.method_31548().method_5438(slot);
            if (stack.method_31574((class_1792)IllusoryWallsMod.STAFF_OF_ILLUSION_ITEM) && handStack.method_7960()) {
                PlayerInfo.get(player).setCanSeeIllusoryWalls(false);
            }
        });
        PlayerInventoryHooks.DROP_ITEM.register((player, slot, inInventory) -> {
            if (player.method_73183().method_8608()) {
                return false;
            }
            class_1661 inventory = player.method_31548();
            if (slot < 0 || slot >= inventory.method_5439()) {
                return false;
            }
            class_1799 stack = inventory.method_5438(slot);
            if (stack.method_31574((class_1792)IllusoryWallsMod.STAFF_OF_ILLUSION_ITEM)) {
                PlayerInfo.get((class_3222)player).setCanSeeIllusoryWalls(false);
            }
            return false;
        });
        PlayerInventoryHooks.PLAYER_PICKED_UP.register((player, itemEntity) -> {
            if (player.method_73183().method_8608()) {
                return;
            }
            PlayerInfo.get((class_3222)player).updatePlayerCanSeeIllusoryWalls();
        });
    }
}

