/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.illwalls.network;

import java.util.Collection;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8705;
import net.minecraft.class_8710;
import work.lclpnet.illwalls.IllusoryWallsMod;
import work.lclpnet.illwalls.entity.IllusoryWallEntity;
import work.lclpnet.illwalls.network.ApplyWallSettingsC2SPacket;
import work.lclpnet.illwalls.network.AttackBlockAdventureC2SPacket;
import work.lclpnet.illwalls.network.EditWallScreenS2CPacket;
import work.lclpnet.illwalls.network.EntityExtraSpawnS2CPacket;
import work.lclpnet.illwalls.network.StructureUpdateS2CPacket;
import work.lclpnet.illwalls.util.PlayerInfo;
import work.lclpnet.illwalls.wall.IllusoryWallManager;
import work.lclpnet.illwalls.wall.IllusoryWallPlayerSettings;

public class ServerNetworkHandler {
    private final IllusoryWallManager wallManager;

    public ServerNetworkHandler(IllusoryWallManager wallManager) {
        this.wallManager = wallManager;
    }

    public void init() {
        PayloadTypeRegistry playS2C = PayloadTypeRegistry.playS2C();
        playS2C.register(EntityExtraSpawnS2CPacket.ID, EntityExtraSpawnS2CPacket.CODEC);
        playS2C.register(StructureUpdateS2CPacket.ID, StructureUpdateS2CPacket.CODEC);
        playS2C.register(EditWallScreenS2CPacket.ID, EditWallScreenS2CPacket.CODEC);
        PayloadTypeRegistry playC2S = PayloadTypeRegistry.playC2S();
        playC2S.register(ApplyWallSettingsC2SPacket.ID, ApplyWallSettingsC2SPacket.CODEC);
        playC2S.register(AttackBlockAdventureC2SPacket.ID, AttackBlockAdventureC2SPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ApplyWallSettingsC2SPacket.ID, this::applyWallSettings);
        ServerPlayNetworking.registerGlobalReceiver(AttackBlockAdventureC2SPacket.ID, this::attackBlockAdventure);
    }

    private void applyWallSettings(ApplyWallSettingsC2SPacket payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        if (!player.method_7338()) {
            return;
        }
        class_3218 world = player.method_51469();
        world.method_8503().execute(() -> {
            class_1297 entity;
            int entityId = payload.entityId();
            IllusoryWallEntity wallEntity = null;
            if (entityId != -1 && (entity = world.method_8469(entityId)) instanceof IllusoryWallEntity) {
                wallEntity = (IllusoryWallEntity)entity;
            }
            IllusoryWallPlayerSettings settings = payload.settings();
            if (wallEntity != null) {
                settings.applyTo(wallEntity);
            } else {
                PlayerInfo.get(player).getWallSettings().copyFrom(settings);
            }
        });
    }

    private void attackBlockAdventure(AttackBlockAdventureC2SPacket payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        class_3218 world = player.method_51469();
        world.method_8503().execute(() -> {
            class_2338 pos = payload.pos();
            if (player.method_7325()) {
                return;
            }
            if (!player.method_56093(pos, 1.0)) {
                return;
            }
            if (!player.method_21701((class_1937)world, pos, player.field_13974.method_14257())) {
                return;
            }
            class_1799 stack = player.method_6047();
            if (stack.method_31574((class_1792)IllusoryWallsMod.STAFF_OF_ILLUSION_ITEM)) {
                return;
            }
            class_2350 direction = payload.direction();
            class_2338 from = pos.method_10093(direction);
            this.wallManager.fadeWallAtIfPresent(world, pos, from);
        });
    }

    public static void send(class_8710 packet, Collection<class_3222> players) {
        players.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)packet));
    }

    public static <T extends class_8705> class_2596<T> createS2CPacket(class_8710 packet) {
        return ServerPlayNetworking.createS2CPacket((class_8710)packet);
    }
}

