/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.illwalls.render;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_765;
import net.minecraft.class_776;
import work.lclpnet.illwalls.render.BlockIllusionRenderManager;
import work.lclpnet.illwalls.render.CullStructureRenderer;
import work.lclpnet.illwalls.render.RenderLayerGetter;
import work.lclpnet.illwalls.render.StructureEntityRenderState;
import work.lclpnet.illwalls.render.StructureRenderer;

@Environment(value=EnvType.CLIENT)
public class StructureEntityBatchRenderer
implements RenderLayerGetter {
    private final List<Command> commands = new ArrayList<Command>();
    private final class_4587 matrices = new class_4587();
    private final class_4597.class_4598 vertexConsumers;
    private final StructureRenderer structureRenderer;

    public StructureEntityBatchRenderer(class_4597.class_4598 vertexConsumers, class_776 blockRenderManager) {
        this.vertexConsumers = vertexConsumers;
        BlockIllusionRenderManager blockIllusionRenderManager = new BlockIllusionRenderManager(blockRenderManager, this);
        this.structureRenderer = new CullStructureRenderer(blockIllusionRenderManager);
    }

    public void submit(class_4587 matrices, StructureEntityRenderState state) {
        this.commands.add(new Command(matrices.method_23760().method_56822(), state));
    }

    public void render() {
        for (Command command : this.commands) {
            this.matrices.method_22903();
            this.matrices.method_23760().method_66521(command.matricesEntry());
            this.render(command);
            this.matrices.method_22909();
        }
        this.commands.clear();
    }

    private void render(Command command) {
        float alpha = 1.0f;
        StructureEntityRenderState state = command.renderState;
        if (state.fading) {
            long start = state.fadeStartMs;
            if (start == 0L) {
                start = System.currentTimeMillis();
            }
            long now = System.currentTimeMillis();
            alpha = (float)(now - start) / 1000.0f;
            if (state.fadeMode != 1) {
                alpha = 1.0f - alpha;
            }
            alpha = class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f);
        }
        class_2338 fadingFrom = state.fadingFrom;
        int light = state.field_61820;
        if (fadingFrom != null) {
            light = class_765.method_23687((int)state.blockLight, (int)state.skyLight);
        }
        this.structureRenderer.render(state.structure, state.field_53325, state.field_53326, state.field_53327, this.matrices, (class_4597)this.vertexConsumers, light, alpha);
    }

    @Override
    public class_1921 getRenderLayer(class_2680 state, float alpha) {
        if (alpha >= 1.0f) {
            return class_4696.method_23683((class_2680)state);
        }
        return class_4722.method_29382();
    }

    @Environment(value=EnvType.CLIENT)
    public record Command(class_4587.class_4665 matricesEntry, StructureEntityRenderState renderState) {
    }
}

