/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.illwalls.screen;

import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import net.minecraft.class_7842;
import net.minecraft.class_8021;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import work.lclpnet.illwalls.entity.IllusoryWallEntity;
import work.lclpnet.illwalls.network.ApplyWallSettingsC2SPacket;
import work.lclpnet.illwalls.screen.lib.RowWidget;
import work.lclpnet.illwalls.screen.lib.UiBuilder;
import work.lclpnet.illwalls.util.McTimeUnit;
import work.lclpnet.illwalls.wall.IllusoryWallPlayerSettings;

@Environment(value=EnvType.CLIENT)
public class EditWallScreen
extends class_437 {
    private final int OFFSET_Y = 20;
    private final UiBuilder uiBuilder = new UiBuilder(50, 4);
    private final IllusoryWallPlayerSettings settings;
    @Nullable
    private final IllusoryWallEntity entity;
    private class_4286 respawnCheckbox = null;
    private class_7842 cooldownHeader = null;
    private class_342 cooldownInput = null;
    private class_5676<McTimeUnit> unitButton = null;
    private McTimeUnit prevUnit = null;

    public EditWallScreen(IllusoryWallPlayerSettings settings, @Nullable IllusoryWallEntity entity) {
        super((class_2561)class_2561.method_43471((String)(entity != null ? "illusory_wall.edit" : "illusory_wall.edit_defaults")));
        this.settings = settings;
        this.entity = entity;
    }

    protected void method_25426() {
        boolean shouldRespawn = this.settings.shouldRespawn();
        this.respawnCheckbox = class_4286.method_54787((class_2561)class_2561.method_43471((String)"illusory_wall.edit.respawn"), (class_327)this.field_22793).method_54789(0, 0).method_54794(shouldRespawn).method_54791((checkbox, checked) -> {
            if (checked) {
                this.addCooldownUi();
            } else {
                this.removeCooldownUi();
            }
        }).method_54788();
        this.method_37063((class_364)this.respawnCheckbox);
        this.uiBuilder.add((class_8021)this.respawnCheckbox);
        this.uiBuilder.resize(this.field_22789);
        if (shouldRespawn) {
            this.addCooldownUi();
        }
    }

    private void addCooldownUi() {
        McTimeUnit cooldownUnit;
        this.removeCooldownUi();
        this.cooldownInput = new class_342(this.field_22793, 0, 25, 60, 20, (class_2561)class_2561.method_43471((String)"illusory_wall.edit.respawn_duration"));
        this.cooldownHeader = new class_7842((class_2561)class_2561.method_43471((String)"illusory_wall.edit.cooldown"), this.field_22793);
        this.prevUnit = cooldownUnit = this.restoreState(this.cooldownInput);
        this.unitButton = new class_5676.class_5677(McTimeUnit::asText).method_32624((Object[])McTimeUnit.values()).method_32619((Object)cooldownUnit).method_32617(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"illusory_wall.edit.unit"), (btn, unit) -> this.changeUnit((McTimeUnit)((Object)unit)));
        RowWidget cooldownRow = new RowWidget(4, new class_8021[]{this.cooldownInput, this.unitButton});
        this.uiBuilder.reset();
        this.uiBuilder.add((class_8021)this.respawnCheckbox);
        this.uiBuilder.add((class_8021)this.cooldownHeader, 14);
        this.uiBuilder.add((class_8021)cooldownRow);
        this.uiBuilder.resize(this.field_22789);
        this.method_37060((class_4068)this.cooldownHeader);
        this.method_37063((class_364)this.cooldownInput);
        this.method_37063((class_364)this.unitButton);
    }

    private void removeCooldownUi() {
        if (this.cooldownHeader != null) {
            this.method_37066((class_364)this.cooldownHeader);
        }
        if (this.cooldownInput != null) {
            this.method_37066((class_364)this.cooldownInput);
        }
        if (this.unitButton != null) {
            this.method_37066((class_364)this.unitButton);
        }
        this.uiBuilder.reset();
    }

    @NotNull
    private McTimeUnit restoreState(class_342 cooldownInput) {
        McTimeUnit cooldownUnit;
        int cooldownValue;
        int ticks = this.settings.getRespawnDuration();
        if (ticks < 0) {
            cooldownValue = 60;
            cooldownUnit = McTimeUnit.SECONDS;
        } else {
            cooldownUnit = McTimeUnit.getBiggestFittingTimeUnit(ticks);
            cooldownValue = cooldownUnit.fromTicks(ticks);
        }
        cooldownInput.method_1852(String.valueOf(cooldownValue));
        return cooldownUnit;
    }

    private void changeUnit(McTimeUnit newUnit) {
        McTimeUnit prevUnit = this.prevUnit;
        this.prevUnit = newUnit;
        if (this.cooldownInput == null) {
            return;
        }
        this.getCooldown(this.cooldownInput).ifPresent(value -> {
            boolean wasZero = value == 0;
            value = newUnit.fromTicks(prevUnit.toTicks(value));
            if (!wasZero) {
                value = Math.max(value, 1);
            }
            this.cooldownInput.method_1852(String.valueOf(value));
        });
    }

    private OptionalInt getCooldown(class_342 textField) {
        String text = textField.method_1882().trim();
        try {
            int value = Integer.parseInt(text);
            return OptionalInt.of(Math.max(0, value));
        }
        catch (NumberFormatException ignored) {
            return OptionalInt.empty();
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.uiBuilder.resize(width);
    }

    public void method_25393() {
        if (this.entity != null && this.entity.method_31481()) {
            this.method_25419();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_52752(context);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25419() {
        super.method_25419();
        this.applySettings();
    }

    private void applySettings() {
        if (this.respawnCheckbox == null) {
            return;
        }
        OptionalInt respawnDuration = this.getRespawnDurationTicks(this.respawnCheckbox);
        if (respawnDuration.isEmpty()) {
            return;
        }
        this.settings.setRespawnDuration(respawnDuration.getAsInt());
        ApplyWallSettingsC2SPacket packet = new ApplyWallSettingsC2SPacket(this.settings, this.entity);
        ClientPlayNetworking.send((class_8710)packet);
    }

    private OptionalInt getRespawnDurationTicks(class_4286 respawnCheckbox) {
        if (!respawnCheckbox.method_20372()) {
            return OptionalInt.of(-1);
        }
        if (this.cooldownInput == null || this.unitButton == null) {
            return OptionalInt.empty();
        }
        OptionalInt cooldown = this.getCooldown(this.cooldownInput);
        if (cooldown.isEmpty()) {
            return OptionalInt.empty();
        }
        McTimeUnit unit = (McTimeUnit)((Object)this.unitButton.method_32603());
        return OptionalInt.of(unit.toTicks(cooldown.getAsInt()));
    }
}

