/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.illwalls.screen.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_8021;
import net.minecraft.class_8133;

@Environment(value=EnvType.CLIENT)
public class UiBuilder {
    private final int initialY;
    private final int marginTop;
    private final List<Entry> entries = new ArrayList<Entry>();
    private int width = 0;
    private int currentY;

    public UiBuilder(int initialY, int marginTop) {
        this.initialY = initialY;
        this.marginTop = marginTop;
        this.reset();
    }

    public void reset() {
        this.resetY();
        this.entries.clear();
    }

    private void resetY() {
        this.currentY = this.initialY;
    }

    public void add(class_8021 widget) {
        this.add(widget, this.marginTop);
    }

    public void add(class_8021 widget, int marginTop) {
        Objects.requireNonNull(widget);
        Entry entry = new Entry(widget, marginTop);
        this.entries.add(entry);
    }

    public void resize(int width) {
        this.width = width;
        this.resetY();
        for (Entry entry : this.entries) {
            entry.update();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class Entry {
        private final class_8021 widget;
        private final int marginTop;

        private Entry(class_8021 widget, int marginTop) {
            this.widget = widget;
            this.marginTop = marginTop;
        }

        public void update() {
            int widgetWidth = this.widget.method_25368();
            int widgetHeight = this.widget.method_25364();
            this.widget.method_46421((UiBuilder.this.width - widgetWidth) / 2);
            this.widget.method_46419(UiBuilder.this.currentY + this.marginTop);
            UiBuilder.this.currentY += this.marginTop + widgetHeight;
            class_8021 class_80212 = this.widget;
            if (class_80212 instanceof class_8133) {
                class_8133 layout = (class_8133)class_80212;
                layout.method_48222();
            }
        }
    }
}

