/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.illwalls.struct;

import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import work.lclpnet.illwalls.network.ServerNetworkHandler;
import work.lclpnet.illwalls.network.StructureUpdateS2CPacket;
import work.lclpnet.illwalls.struct.EmptyBlockState;
import work.lclpnet.illwalls.struct.ExtendedBlockStateAdapter;
import work.lclpnet.illwalls.struct.ExtendedStructureWrapper;
import work.lclpnet.illwalls.struct.ListenerStructureWrapper;
import work.lclpnet.illwalls.struct.StructureBatchUpdate;
import work.lclpnet.kibu.mc.KibuBlockPos;
import work.lclpnet.kibu.mc.KibuBlockState;
import work.lclpnet.kibu.schematic.FabricStructureWrapper;
import work.lclpnet.kibu.structure.BlockStructure;
import work.lclpnet.kibu.structure.SimpleBlockStructure;

public class StructureContainer {
    private final class_1297 entity;
    private ExtendedStructureWrapper structure;

    public StructureContainer(class_1297 entity) {
        this.entity = entity;
        this.structure = this.makeStructure((BlockStructure)FabricStructureWrapper.createSimpleStructure());
    }

    private boolean existsInWorld() {
        return this.entity.method_73183().method_8469(this.entity.method_5628()) != null;
    }

    private void onUpdate(class_2338 pos, class_2680 state) {
        Object object;
        if (this.entity.method_73183().method_8608()) {
            return;
        }
        if (this.structure.getStructure().isEmpty()) {
            this.entity.method_31472();
            return;
        }
        StructureContainer.center(this.entity, this.structure);
        SimpleBlockStructure deltaStructure = FabricStructureWrapper.createSimpleStructure();
        ExtendedBlockStateAdapter adapter = ExtendedBlockStateAdapter.getInstance();
        if (pos == null && state == null && (object = this.structure) instanceof StructureBatchUpdate) {
            StructureBatchUpdate batchUpdate = (StructureBatchUpdate)object;
            for (Map.Entry entry : batchUpdate.getBatch().entrySet()) {
                class_2338 batchPos = (class_2338)entry.getKey();
                class_2680 batchState = (class_2680)entry.getValue();
                EmptyBlockState deltaState = batchState.method_26215() ? EmptyBlockState.INSTANCE : adapter.adapt(batchState);
                deltaStructure.setBlockState(adapter.adapt((class_2382)batchPos), (KibuBlockState)deltaState);
            }
        } else if (pos != null && state != null) {
            EmptyBlockState deltaState = state.method_26215() ? EmptyBlockState.INSTANCE : adapter.adapt(state);
            deltaStructure.setBlockState(adapter.adapt((class_2382)pos), (KibuBlockState)deltaState);
        }
        if (!deltaStructure.isEmpty()) {
            this.updateStructure((BlockStructure)deltaStructure);
        }
    }

    public void updateStructure(BlockStructure delta) {
        if (!this.entity.method_73183().method_8608()) {
            if (!this.existsInWorld()) {
                return;
            }
            StructureUpdateS2CPacket updatePacket = new StructureUpdateS2CPacket(this.entity.method_5628(), delta);
            ServerNetworkHandler.send(updatePacket, PlayerLookup.tracking((class_1297)this.entity));
            return;
        }
        ExtendedStructureWrapper deltaWrapper = new ExtendedStructureWrapper(delta);
        Iterable positions = deltaWrapper.getBlockPositions();
        positions.forEach(pos -> this.structure.setBlockState((class_2338)pos, deltaWrapper.method_8320((class_2338)pos)));
    }

    private ExtendedStructureWrapper makeStructure(BlockStructure structure) {
        return new ListenerStructureWrapper(structure, this::onUpdate);
    }

    public ExtendedStructureWrapper getWrapper() {
        return this.structure;
    }

    public void setStructure(BlockStructure structure) {
        this.structure = this.makeStructure(structure);
    }

    public static void center(class_1297 entity, ExtendedStructureWrapper structure) {
        class_2338 center = structure.getCenter();
        int centerX = center.method_10263();
        int centerY = center.method_10264();
        int centerZ = center.method_10260();
        class_2338 currentPos = entity.method_24515();
        if (currentPos.method_10263() == centerX && currentPos.method_10264() == centerY && currentPos.method_10260() == centerZ) {
            return;
        }
        entity.method_5814((double)centerX, (double)centerY, (double)centerZ);
    }

    public static SimpleBlockStructure createMutableStructure(int width, int height, int length, KibuBlockPos origin, int dataVersion) {
        return new SimpleBlockStructure(dataVersion);
    }
}

