/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.illwalls.util;

import java.util.Collection;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import work.lclpnet.illwalls.IllusoryWallsApi;
import work.lclpnet.illwalls.IllusoryWallsMod;
import work.lclpnet.illwalls.entity.EntityTrackingUpdatable;
import work.lclpnet.illwalls.entity.IllusoryWallEntity;
import work.lclpnet.illwalls.util.PlayerInfoView;
import work.lclpnet.illwalls.wall.IllusoryWallPlayerSettings;

public class PlayerInfo {
    private final class_3222 player;
    private boolean seeIllusoryWalls = false;
    private volatile IllusoryWallPlayerSettings wallSettings = null;

    private PlayerInfo(class_3222 player) {
        this.player = player;
    }

    public boolean canSeeIllusoryWalls() {
        return this.seeIllusoryWalls;
    }

    public void setCanSeeIllusoryWalls(boolean canSeeIllusoryWalls) {
        if (this.seeIllusoryWalls == canSeeIllusoryWalls) {
            return;
        }
        this.seeIllusoryWalls = canSeeIllusoryWalls;
        class_3218 world = this.player.method_51469();
        class_3898 chunkManager = world.method_14178().field_17254;
        if (!(chunkManager instanceof EntityTrackingUpdatable)) {
            return;
        }
        EntityTrackingUpdatable entityTrackingUpdatable = (EntityTrackingUpdatable)chunkManager;
        Collection<IllusoryWallEntity> entities = IllusoryWallsApi.getInstance().lookup().getAll(world);
        for (IllusoryWallEntity entity : entities) {
            entityTrackingUpdatable.illwalls$updateTrackedStatus(entity, this.player);
        }
    }

    public void updatePlayerCanSeeIllusoryWalls() {
        boolean shouldSeeWalls = this.shouldSeeIllusoryWalls();
        this.setCanSeeIllusoryWalls(shouldSeeWalls);
    }

    private boolean shouldSeeIllusoryWalls() {
        if (!this.player.method_7338()) {
            return false;
        }
        class_1799 stack = this.player.method_5998(class_1268.field_5808);
        if (stack.method_31574((class_1792)IllusoryWallsMod.STAFF_OF_ILLUSION_ITEM)) {
            return true;
        }
        stack = this.player.method_5998(class_1268.field_5810);
        return stack.method_31574((class_1792)IllusoryWallsMod.STAFF_OF_ILLUSION_ITEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IllusoryWallPlayerSettings getWallSettings() {
        if (this.wallSettings != null) {
            return this.wallSettings;
        }
        PlayerInfo playerInfo = this;
        synchronized (playerInfo) {
            if (this.wallSettings != null) {
                return this.wallSettings;
            }
            this.wallSettings = new IllusoryWallPlayerSettings();
        }
        return this.wallSettings;
    }

    public static PlayerInfo create(class_3222 player) {
        return new PlayerInfo(player);
    }

    public static PlayerInfo get(class_3222 player) {
        return ((PlayerInfoView)player).illwalls$getPlayerInfo();
    }
}

