/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.illwalls.wall;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import work.lclpnet.illwalls.IllusoryWallsMod;
import work.lclpnet.illwalls.entity.IllusoryWallEntity;
import work.lclpnet.illwalls.struct.ExtendedStructureWrapper;
import work.lclpnet.illwalls.struct.StructureBatchUpdate;
import work.lclpnet.illwalls.util.PlayerInfo;
import work.lclpnet.illwalls.wall.IllusoryWallLookup;
import work.lclpnet.illwalls.wall.IllusoryWallManager;

public class SimpleIllusoryWallManager
implements IllusoryWallManager {
    private final IllusoryWallLookup wallLookup;

    public SimpleIllusoryWallManager(IllusoryWallLookup wallLookup) {
        this.wallLookup = Objects.requireNonNull(wallLookup);
    }

    @Override
    public boolean fadeWallAtIfPresent(class_3218 world, class_2338 pos, @Nullable class_2338 from) {
        Optional<IllusoryWallEntity> optWall = this.wallLookup.getWallAt(world, pos);
        if (optWall.isEmpty()) {
            return false;
        }
        IllusoryWallEntity entity = optWall.get();
        entity.fade(from);
        return true;
    }

    @Override
    public boolean makeBlockIllusory(class_3218 world, class_2338 pos, @Nullable class_3222 player) {
        StructureBatchUpdate batchUpdate;
        if (this.wallLookup.getWallAt(world, pos).isPresent()) {
            return false;
        }
        HashSet nearbyWalls = new HashSet();
        class_2338.class_2339 adjPos = new class_2338.class_2339();
        for (class_2350 direction : class_2350.values()) {
            adjPos.method_25505((class_2382)pos, direction);
            Optional<IllusoryWallEntity> opt = this.wallLookup.getWallAt(world, (class_2338)adjPos);
            opt.ifPresent(nearbyWalls::add);
        }
        if (nearbyWalls.isEmpty()) {
            IllusoryWallEntity wall = (IllusoryWallEntity)IllusoryWallsMod.ILLUSORY_WALL_ENTITY.method_5899(world, created -> {
                ExtendedStructureWrapper structure = created.getStructureContainer().getWrapper();
                structure.setBlockState(pos, world.method_8320(pos));
            }, pos, class_3730.field_16465, false, false);
            if (player != null && wall != null) {
                PlayerInfo.get(player).getWallSettings().applyTo(wall);
            }
            return true;
        }
        Iterator iterator = nearbyWalls.iterator();
        IllusoryWallEntity wall = (IllusoryWallEntity)iterator.next();
        ExtendedStructureWrapper structure = wall.getStructureContainer().getWrapper();
        if (!iterator.hasNext()) {
            structure.setBlockState(pos, world.method_8320(pos));
            return true;
        }
        StructureBatchUpdate structureBatchUpdate = batchUpdate = structure instanceof StructureBatchUpdate ? (StructureBatchUpdate)((Object)structure) : null;
        if (batchUpdate != null) {
            batchUpdate.beginBatch();
        }
        structure.setBlockState(pos, world.method_8320(pos));
        while (iterator.hasNext()) {
            IllusoryWallEntity other = (IllusoryWallEntity)iterator.next();
            ExtendedStructureWrapper otherStructure = other.getStructureContainer().getWrapper();
            otherStructure.copyTo(structure);
            other.method_31472();
        }
        if (batchUpdate != null) {
            batchUpdate.endBatch();
        }
        return true;
    }

    @Override
    public boolean removeIllusoryBlock(class_3218 world, class_2338 pos) {
        Optional<IllusoryWallEntity> optWall = this.wallLookup.getWallAt(world, pos);
        if (optWall.isEmpty()) {
            return false;
        }
        IllusoryWallEntity entity = optWall.get();
        ExtendedStructureWrapper structure = entity.getStructureContainer().getWrapper();
        structure.setBlockState(pos, class_2246.field_10124.method_9564());
        return true;
    }
}

