package net.wizardsoflua.command.dynamic;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2168;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;

public class CommandDef {
  private final String pattern;
  private final String code;
  private final int level;
  private final ParseResult parseResult;
  private Set<String> oldNodes = new HashSet<>();
  private Set<CommandNode<class_2168>> createdNodes = new HashSet<>();

  public CommandDef(String pattern, String code, int level, ParseResult parseResult) {
    this.pattern = pattern;
    this.code = code;
    this.level = level;
    this.parseResult = parseResult;
  }

  public int getLevel() {
    return level;
  }

  public String getCode() {
    return code;
  }

  public List<Token> getTokens() {
    return parseResult.tokens();
  }

  public String getPattern() {
    return pattern;
  }

  public String getTokenPath(int index) {
    return parseResult.getTokenPath(index);
  }

  public int findLastPlaceholderIndex() {
    int last = -1;
    for (int i = 0; i < getTokens().size(); i++) {
      if (getTokens().get(i).isPlaceholder())
        last = i;
    }
    return last;
  }

  public Collection<String> getTokenPaths() {
    return parseResult.getTokenPaths();
  }

  public Set<CommandNode<class_2168>> getCreatedNodes() {
    return createdNodes;
  }

  public void check(CommandDispatcher<class_2168> dispatcher,
      Set<CommandNode<class_2168>> allowedNodes) {
    CommandNode<class_2168> current = dispatcher.getRoot();
    Set<Token> oldNodes = new HashSet<>();
    for (Token tok : getTokens()) {
      String nodeName = tok.tokenName();
      CommandNode<class_2168> child = current.getChild(nodeName);
      if (child == null) {
        break;
      }
      oldNodes.add(tok);
      current = child;
    }
    if (oldNodes.size() == getTokens().size()) {
      if (!allowedNodes.contains(current)) {
        throw new IllegalArgumentException(
            "It's not allowed to replace an existing command: " + getPattern());
      }
    }
  }

  public void register(CommandDispatcher<class_2168> dispatcher,
      LiteralArgumentBuilder<class_2168> command) {
    oldNodes.clear();
    {
      CommandNode<class_2168> current = dispatcher.getRoot();
      for (Token tok : getTokens()) {
        String nodeName = tok.tokenName();
        CommandNode<class_2168> child = current.getChild(nodeName);
        if (child == null) {
          break;
        }
        oldNodes.add(tok.tokenPath());
        current = child;
      }
    }
    dispatcher.register(command);
    {
      CommandNode<class_2168> current = dispatcher.getRoot();
      for (Token tok : getTokens()) {
        String nodeName = tok.tokenName();
        CommandNode<class_2168> child = current.getChild(nodeName);
        if (!oldNodes.contains(tok.tokenPath())) {
          if (child == null) {
            throw new IllegalStateException("child==null!");
          }
          createdNodes.add(child);
        }
        current = child;
      }
    }
  }

  public void deregister(CommandDispatcher<class_2168> dispatcher,
      CommandNodeRemover commandNodeRemover) {
    CommandNode<class_2168> current = dispatcher.getRoot();
    for (Token tok : getTokens()) {
      String nodeName = tok.tokenName();
      CommandNode<class_2168> child = current.getChild(nodeName);
      if (child == null) {
        // child has been removed externally. Maybe a reload occurred?
        break;
      }
      if (!oldNodes.contains(tok.tokenPath())) {
        commandNodeRemover.removeChildFrom(current, child);
        break;
      }
      current = child;
    }
    oldNodes.clear();
  }
}
