package net.wizardsoflua.command.dynamic;

import static com.google.common.base.Preconditions.checkArgument;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;

public record ParseResult(List<Token> tokens) {
  public ParseResult {
    checkArgument(!tokens.isEmpty(), "tokens must not be empty!");
    checkArgument(!tokens.get(0).isPlaceholder(), "first token must not be a placeholder!");
  }

  public Collection<String> getTokenPaths() {
    return IntStream.range(0, tokens.size()).mapToObj(i -> getTokenPath(i)).toList();
  }

  public String getTokenPath(int index) {
    return tokens.get(index).tokenPath();
  }
}
