package net.wizardsoflua.command.dynamic;

import static net.minecraft.class_2170.method_9244;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_2287;
import net.minecraft.class_7157;

/**
 * Supported placeholder types for dynamic commands.
 */
public enum Placeholder {

  STRING("s", "string",
      (argName, greedy, ra) -> method_9244(argName,
          greedy ? StringArgumentType.greedyString() : StringArgumentType.string()),
      (ctx, argName, ra) -> StringArgumentType.getString(ctx, argName)),

  DOUBLE("d", "decimal", (argName, greedy, ra) -> method_9244(argName, DoubleArgumentType.doubleArg()),
      (ctx, argName, ra) -> DoubleArgumentType.getDouble(ctx, argName)),

  INTEGER("i", "integer", (argName, greedy, ra) -> method_9244(argName, IntegerArgumentType.integer()),
      (ctx, argName, ra) -> IntegerArgumentType.getInteger(ctx, argName)),

  BOOLEAN("b", "boolean", (argName, greedy, ra) -> method_9244(argName, BoolArgumentType.bool()),
      (ctx, argName, ra) -> BoolArgumentType.getBool(ctx, argName)),

  VECTOR("v", "vector", (argName, greedy, ra) -> method_9244(argName, class_2277.method_9737()),
      (ctx, argName, ra) -> class_2277.method_9736(ctx, argName)),

  ENTITY("entity", "entity",
      (argName, greedy, ra) -> method_9244(argName, class_2186.method_9309()),
      (ctx, argName, ra) -> {
        try {
          return class_2186.method_9313(ctx, argName);
        } catch (CommandSyntaxException e) {
          return null;
        }
      }),

  ENTITIES("entities", "entities",
      (argName, greedy, ra) -> method_9244(argName, class_2186.method_9306()),
      (ctx, argName, ra) -> {
        try {
          return class_2186.method_9317(ctx, argName);
        } catch (CommandSyntaxException e) {
          return null;
        }
      }),

  PLAYER("player", "player",
      (argName, greedy, ra) -> method_9244(argName, class_2186.method_9305()),
      (ctx, argName, ra) -> {
        try {
          return class_2186.method_9315(ctx, argName);
        } catch (CommandSyntaxException e) {
          return null;
        }
      }),

  PLAYERS("players", "players",
      (argName, greedy, ra) -> method_9244(argName, class_2186.method_9308()),
      (ctx, argName, ra) -> {
        try {
          return class_2186.method_9312(ctx, argName);
        } catch (CommandSyntaxException e) {
          return null;
        }
      }),

  ITEM("item", "item",
      (argName, greedy, ra) -> method_9244(argName, class_2287.method_9776(ra)),
      (ctx, argName, ra) -> {
        try {
          return class_2287.method_9777(ctx, argName).method_9781(1, false);
        } catch (CommandSyntaxException e) {
          return null;
        }
      });

  private final String code;
  private final String name;
  private final ArgBuilder builderFactory;
  private final ArgExtractor extractor;

  Placeholder(String code, String name, ArgBuilder builderFactory, ArgExtractor extractor) {
    this.code = code;
    this.name = name;
    this.builderFactory = builderFactory;
    this.extractor = extractor;
  }

  /** The literal code (e.g. "s", "d", "item", "players"). */
  public String getCode() {
    return code;
  }

  public String getName() {
    return name;
  }

  /** Build the Brigadier node for this placeholder. */
  public ArgumentBuilder<class_2168, ?> createBuilder(String name, boolean greedyString,
      class_7157 registryAccess) {
    return builderFactory.build(name, greedyString, registryAccess);
  }

  /** Extract the parsed value from the context. */
  public Object extract(CommandContext<class_2168> ctx, String name,
      class_7157 registryAccess) {
    return extractor.extract(ctx, name, registryAccess);
  }

  /** Lookup by code, e.g. byCode("e") → ENTITY or byCode("players") → PLAYERS. */
  public static Placeholder byCode(String code) {
    for (Placeholder p : values()) {
      if (p.code.equals(code)) {
        return p;
      }
    }
    throw new IllegalArgumentException("Unknown placeholder type '%" + code + "'");
  }

  @FunctionalInterface
  public interface ArgBuilder {
    ArgumentBuilder<class_2168, ?> build(String argName, boolean greedyString,
        class_7157 registryAccess);
  }

  @FunctionalInterface
  public interface ArgExtractor {
    Object extract(CommandContext<class_2168> ctx, String argName,
        class_7157 registryAccess);
  }
}
