package net.wizardsoflua.event;

public interface WolEvent {
  /**
   * Returns <code>true</code> if this event type can be generally be canceled.
   */
  boolean canBeCanceled();

  /**
   * Returns <code>true</code> if the internal event state indicates that this event should not be
   * processed by any interceptor.
   */
  default boolean shouldAbort() {
    return false;
  }

  default void onBeforeCollect() {}
}
