package net.wizardsoflua.lua;

import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.wizardsoflua.spell.Spell;

public class RaycastUtil {
  public static @Nullable class_239 raycastFromEye(class_1297 entity, double maxDistance) {
    class_3965 blockHitResult = raycastFromEyeToBlock(entity, maxDistance);
    class_3966 entityHitResult = raycastFromEyeToEntity(entity, maxDistance);
    class_243 fromPos = entity.method_33571();
    double d = blockHitResult == null ? Double.MAX_VALUE
        : fromPos.method_1025(blockHitResult.method_17784());
    double e = entityHitResult == null ? Double.MAX_VALUE
        : fromPos.method_1025(entityHitResult.method_17784());
    return d <= e ? blockHitResult : entityHitResult;
  }

  public static @Nullable class_3965 raycastFromEyeToBlock(class_1297 entity, double maxDistance) {
    class_243 fromPos = entity.method_33571();
    class_243 toPos = fromPos.method_1019(getLookVector(entity, maxDistance));
    class_1937 world = entity.method_73183();
    class_3959 ctx = new class_3959(fromPos, toPos, class_3959.class_3960.field_17559,
        class_3959.class_242.field_1348, entity);
    return world.method_17742(ctx);
  }

  public static @Nullable class_3966 raycastFromEyeToEntity(class_1297 entity,
      double maxDistance) {
    class_243 fromPos = entity.method_33571();
    class_243 toPos = fromPos.method_1019(getLookVector(entity, maxDistance));
    Predicate<class_1297> predicate = it -> !it.method_7325() && it.method_5863();
    class_243 lookOffset = entity.method_5828(1.0F).method_1021((double) maxDistance);
    class_238 box = entity.method_5829().method_18804(lookOffset).method_1014(1.0);
    return class_1675.method_18075(entity, fromPos, toPos, box, predicate,
        class_3532.method_33723(maxDistance));
  }

  public static class_243 getLookVector(class_1297 entity, double length) {
    return entity.method_5631(entity.method_36455(), entity.method_36454()).method_1021(length);
  }

  public static @Nullable class_239 raycast(Spell spell, double maxDistance,
      boolean excludeSpellOwner) {
    class_3965 blockHitResult = raycastToBlock(spell, maxDistance);
    class_3966 entityHitResult = raycastToEntity(spell, maxDistance, excludeSpellOwner);
    class_243 fromPos = spell.getPos();
    double d = blockHitResult == null ? Double.MAX_VALUE
        : fromPos.method_1025(blockHitResult.method_17784());
    double e = entityHitResult == null ? Double.MAX_VALUE
        : fromPos.method_1025(entityHitResult.method_17784());
    return d <= e ? blockHitResult : entityHitResult;
  }

  public static @Nullable class_3965 raycastToBlock(Spell spell, double maxDistance) {
    class_243 fromPos = spell.getPos();
    class_243 toPos = fromPos.method_1019(spell.getLookVector().method_1021(maxDistance));
    class_1937 world = spell.getWorld();
    class_3959 ctx = new class_3959(fromPos, toPos, class_3959.class_3960.field_17559,
        class_3959.class_242.field_1348, class_3726.method_16194());
    return world.method_17742(ctx);
  }

  public static @Nullable class_3966 raycastToEntity(Spell spell, double maxDistance,
      boolean excludeSpellOwner) {
    class_243 fromPos = spell.getPos();
    class_243 toPos = fromPos.method_1019(spell.getLookVector().method_1021(maxDistance));
    Predicate<class_1297> predicate = it -> !it.method_7325() && it.method_5863();
    class_243 lookOffset = spell.getLookVector().method_1021((double) maxDistance);
    class_238 box = new class_238(spell.getBlockPos()).method_18804(lookOffset).method_1014(1.0);
    class_1297 entity = excludeSpellOwner ? spell.getOwner() : null;
    return raycast(spell, entity, fromPos, toPos, box, predicate, class_3532.method_33723(maxDistance));
  }

  /**
   * For original see {@link ProjectileUtil#raycast(Entity, Vec3d, Vec3d, Box, Predicate<Entity>,
   * double)}
   */
  @Nullable
  private static class_3966 raycast(Spell spell, @Nullable class_1297 entity, class_243 min, class_243 max,
      class_238 box, Predicate<class_1297> predicate, double maxDistance) {
    class_1937 world = spell.getWorld();
    double d = maxDistance;
    class_1297 entity2 = null;
    class_243 vec3d = null;
    class_1297 except = entity;
    for (class_1297 entity3 : world.method_8333(except, box, predicate)) {
      class_238 box2 = entity3.method_5829().method_1014((double) entity3.method_5871());
      Optional<class_243> optional = box2.method_992(min, max);
      if (box2.method_1006(min)) {
        if (d >= 0.0) {
          entity2 = entity3;
          vec3d = (class_243) optional.orElse(min);
          d = 0.0;
        }
      } else if (optional.isPresent()) {
        class_243 vec3d2 = (class_243) optional.get();
        double e = min.method_1025(vec3d2);
        if (e < d || d == 0.0) {
          entity2 = entity3;
          vec3d = vec3d2;
          d = e;
        }
      }
    }
    return entity2 == null ? null : new class_3966(entity2, vec3d);
  }
}
