package net.wizardsoflua.lua.classes;

import java.util.Objects;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.runtime.IllegalOperationAttemptException;
import net.wizardsoflua.extension.spell.api.resource.LuaConverters;
import net.wizardsoflua.lua.table.XDelegatingLuaTable;

public abstract class AbstractLuaInstance<J, LC extends AbstractLuaClass<?, ?>>
    extends XDelegatingLuaTable<J> {
  private final LC luaClass;

  public AbstractLuaInstance(LC luaClass, J javaInstance, boolean allowAdditionalProperties) {
    super(javaInstance, allowAdditionalProperties);
    this.luaClass = Objects.requireNonNull(luaClass, "luaClass");
    super.setMetatable(luaClass);
  }

  @Override
  public Table setMetatable(Table mt) {
    throw new IllegalOperationAttemptException(
        "illegal attempt to modify metatable for lua instance " + this);
  }

  public LC getLuaClass() {
    return luaClass;
  }

  public LuaConverters getConverters() {
    return luaClass.getConverters();
  }

  protected void setDelegate(J delegate) {
    getLuaClass().getInstanceCache().replaceKey(getDelegate(), delegate);
    super.setDelegate(delegate);
  }
}
