package net.wizardsoflua.lua.classes;

import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.wizardsoflua.event.BeforeLivingEntityDamageEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaBeforeLivingEntityDamageEvent< //
    J extends BeforeLivingEntityDamageEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<BeforeLivingEntityDamageEvent, LuaBeforeLivingEntityDamageEvent<BeforeLivingEntityDamageEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("BeforeLivingEntityDamageEvent", spellScope, null);
    }

    @Override
    protected final LuaBeforeLivingEntityDamageEvent<BeforeLivingEntityDamageEvent, Class> createNewLuaInstance(
        BeforeLivingEntityDamageEvent javaInstance) {
      return new LuaBeforeLivingEntityDamageEvent<>(this, javaInstance);
    }
  }

  public LuaBeforeLivingEntityDamageEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("entity", this::getEntity);
    addReadOnly("damageSource", this::getDamageSource);
    addReadOnly("damage", this::getDamage);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getEntity() {
    class_1309 result = getDelegate().entity();
    return getConverters().toLua(result);
  }

  private Object getDamageSource() {
    class_1282 result = getDelegate().damageSource();
    return getConverters().toLua(result);
  }

  private Object getDamage() {
    float result = getDelegate().damage();
    return getConverters().toLua(result);
  }
}
