package net.wizardsoflua.lua.classes;

import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.wizardsoflua.event.BeforeLivingEntityDeathEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaBeforeLivingEntityDeathEvent< //
    J extends BeforeLivingEntityDeathEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<BeforeLivingEntityDeathEvent, LuaBeforeLivingEntityDeathEvent<BeforeLivingEntityDeathEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("BeforeLivingEntityDeathEvent", spellScope, null);
    }

    @Override
    protected final LuaBeforeLivingEntityDeathEvent<BeforeLivingEntityDeathEvent, Class> createNewLuaInstance(
        BeforeLivingEntityDeathEvent javaInstance) {
      return new LuaBeforeLivingEntityDeathEvent<>(this, javaInstance);
    }
  }

  public LuaBeforeLivingEntityDeathEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("entity", this::getEntity);
    addReadOnly("damageSource", this::getDamageSource);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getEntity() {
    class_1309 result = getDelegate().entity();
    return getConverters().toLua(result);
  }

  private Object getDamageSource() {
    class_1282 result = getDelegate().damageSource();
    return getConverters().toLua(result);
  }
}
