package net.wizardsoflua.lua.classes;

import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1275;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5455;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_8942;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.WizardsOfLuaMod;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.spell.SpellScope;

public class LuaBlockEntity< //
    J extends class_2586, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class
      extends AbstractLuaClass<class_2586, LuaBlockEntity<class_2586, Class>> {
    public Class(SpellScope spellScope) {
      super("BlockEntity", spellScope, null);
      addFunction(new PutNbtFunction());
    }

    @Override
    protected final LuaBlockEntity<class_2586, Class> createNewLuaInstance(
        class_2586 javaInstance) {
      return new LuaBlockEntity<>(this, javaInstance);
    }

    class PutNbtFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "putNbt";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        LuaBlockEntity<?, ?> self =
            getConverters().toJava(LuaBlockEntity.class, arg1, 1, "self", getName());
        Table nbt = getConverters().toJava(Table.class, arg2, 2, "nbt", getName());
        self.putNbt(nbt);
        context.getReturnBuffer().setTo();
      }
    }
  }

  public LuaBlockEntity(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("world", this::getWorld);
    if (javaInstance instanceof class_1275) {
      addReadOnly("name", this::getName);
    }
    addReadOnly("pos", this::getPos);
    addReadOnly("type", this::getType);
    add("nbt", this::getNbt, this::setNbt);
  }

  private Object getWorld() {
    return getConverters().toLua(getDelegate().method_10997());
  }

  private Object getName() {
    return getConverters().toLua(((class_1275) getDelegate()).method_5477());
  }

  private Object getPos() {
    return getConverters().toLua(getDelegate().method_11016());
  }

  private Object getType() {
    return getConverters().toLua(getDelegate().method_11017());
  }

  private Object getNbt() {
    J blockEntity = getDelegate();
    class_5455 registryManager = blockEntity.method_10997().method_30349();
    class_2487 result = blockEntity.method_38244(registryManager);
    return NbtConverter.toLua(result);
  }

  public void putNbt(Table nbt) {
    J blockEntity = getDelegate();
    class_2680 oldState = blockEntity.method_11010();
    class_5455 registryManager = blockEntity.method_10997().method_30349();
    class_2487 oldNbt = blockEntity.method_38244(registryManager);
    class_2487 newNbt = getLuaClass().getNbtConverter().merge(oldNbt, nbt);
    try (class_8942.class_11340 logging = new class_8942.class_11340(WizardsOfLuaMod.LOGGER)) {
      class_11368 view = class_11352.method_71417(logging, registryManager, newNbt);
      blockEntity.method_58690(view);
    }
    updateListeners(oldState);
  }

  private void setNbt(Object luaObject) {
    J blockEntity = getDelegate();
    class_2680 oldState = blockEntity.method_11010();
    Table data = getConverters().toJava(Table.class, luaObject, "nbt");
    class_2487 newNbt = getLuaClass().getNbtConverter().merge(new class_2487(), data);
    try (class_8942.class_11340 logging = new class_8942.class_11340(WizardsOfLuaMod.LOGGER)) {
      class_7874 registries = blockEntity.method_10997().method_30349();
      class_11368 view = class_11352.method_71417(logging, registries, newNbt);
      blockEntity.method_58690(view);
    }

    updateListeners(oldState);
  }

  private void updateListeners(class_2680 oldState) {
    J blockEntity = getDelegate();
    blockEntity.method_5431();
    class_1937 world = blockEntity.method_10997();
    class_2338 pos = blockEntity.method_11016();
    class_2680 newState = blockEntity.method_11010();
    world.method_8413(pos, oldState, newState, class_2248.field_31036);
  }
}
